/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.efield.gui.vectorChooser;

import edu.colorado.phet.efield.gui.vectorChooser.VectorListener;
import edu.colorado.phet.efield.gui.vectorChooser.VectorPainter;
import edu.colorado.phet.efield.phys2d_efield.DoublePoint;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JPanel;

public class VectorChooser
extends JPanel
implements MouseListener,
MouseMotionListener {
    int width;
    int height;
    Vector vectorListeners;
    double scaleX;
    double scaleY;
    int dx;
    int dy;
    DoublePoint vec;
    VectorPainter vp;

    public VectorChooser(int n, int n2, double d, double d2, VectorPainter vectorPainter) {
        this.vp = vectorPainter;
        this.scaleX = d;
        this.scaleY = d2;
        this.width = n;
        this.height = n2;
        this.vectorListeners = new Vector();
        this.setSize(new Dimension(n, n2));
        this.setPreferredSize(new Dimension(n, n2));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void addListener(VectorListener vectorListener) {
        this.vectorListeners.add(vectorListener);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.fireChange(mouseEvent.getX(), mouseEvent.getY());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.fireChange(mouseEvent.getX(), mouseEvent.getY());
    }

    private void fireChange(int n, int n2) {
        int n3 = this.width / 2;
        int n4 = this.height / 2;
        this.dx = n - n3;
        this.dy = n2 - n4;
        this.vec = new DoublePoint((double)this.dx * this.scaleX, (double)this.dy * this.scaleY);
        this.repaint();
        this.informListeners(this.vec);
    }

    private void informListeners(DoublePoint doublePoint) {
        for (int i = 0; i < this.vectorListeners.size(); ++i) {
            ((VectorListener)this.vectorListeners.get(i)).vectorChanged(doublePoint);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.fireChange(mouseEvent.getX(), mouseEvent.getY());
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paintComponent(graphics);
        this.vp.paint((Graphics2D)graphics, this.width / 2, this.height / 2, this.dx, this.dy);
    }
}

