/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.efield.electricField;

import edu.colorado.phet.efield.electricField.ElectricFieldSource;
import edu.colorado.phet.efield.gui.Painter;
import edu.colorado.phet.efield.gui.vectorChooser.VectorPainter;
import edu.colorado.phet.efield.phys2d_efield.DoublePoint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Vector;

public class ElectricFieldPainter
implements Painter {
    Vector sources;
    Rectangle r;
    int nX;
    int nY;
    VectorPainter vp;

    public ElectricFieldPainter(int n, int n2, int n3, int n4, int n5, int n6, VectorPainter vectorPainter) {
        this.vp = vectorPainter;
        this.sources = new Vector();
        this.r = new Rectangle(n, n2, n3, n4);
        this.nX = n5;
        this.nY = n6;
    }

    public void setNX(int n) {
        this.nX = n;
    }

    public void setNY(int n) {
        this.nY = n;
    }

    public void addSource(ElectricFieldSource electricFieldSource) {
        this.sources.add(electricFieldSource);
    }

    private DoublePoint fieldAt(double d, double d2) {
        DoublePoint doublePoint = new DoublePoint();
        for (int i = 0; i < this.sources.size(); ++i) {
            ElectricFieldSource electricFieldSource = (ElectricFieldSource)this.sources.get(i);
            DoublePoint doublePoint2 = electricFieldSource.getField(d, d2);
            doublePoint = doublePoint.add(doublePoint2);
        }
        return doublePoint;
    }

    public void paint(Graphics2D graphics2D) {
        double d = (double)this.r.width / (double)this.nX;
        double d2 = (double)this.r.height / (double)this.nY;
        double d3 = this.r.x;
        double d4 = this.r.y;
        for (int i = 0; i < this.nX; ++i) {
            for (int j = 0; j < this.nY; ++j) {
                DoublePoint doublePoint = this.fieldAt(d3, d4);
                this.vp.paint(graphics2D, (int)d3, (int)d4, (int)doublePoint.getX(), (int)doublePoint.getY());
                d4 += d2;
            }
            d3 += d;
            d4 = this.r.y;
        }
    }
}

