/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.efield.core;

import edu.colorado.phet.efield.core.ParticleContainer;
import edu.colorado.phet.efield.core.SystemFactory;
import edu.colorado.phet.efield.gui.ParticlePainter;
import edu.colorado.phet.efield.gui.ParticlePanel;
import edu.colorado.phet.efield.gui.RepaintLaw;
import edu.colorado.phet.efield.phys2d_efield.DoublePoint;
import edu.colorado.phet.efield.phys2d_efield.Law;
import edu.colorado.phet.efield.phys2d_efield.Particle;
import edu.colorado.phet.efield.phys2d_efield.System2D;
import edu.colorado.phet.efield.phys2d_efield.propagators.FourBounds;
import edu.colorado.phet.efield.phys2d_efield.propagators.PositionUpdate;
import edu.colorado.phet.efield.phys2d_efield.propagators.ResetAcceleration;
import edu.colorado.phet.efield.phys2d_efield.propagators.VelocityUpdate;
import java.util.Random;
import java.util.Vector;

public class RandomSystemFactory
implements SystemFactory {
    int seed;
    int numParticles;
    int minX;
    int minY;
    int width;
    int height;
    Vector forceLaws = new Vector();

    public RandomSystemFactory(int n, int n2, int n3, int n4, int n5, int n6) {
        this.seed = n;
        this.numParticles = n2;
        this.minX = n3;
        this.minY = n4;
        this.width = n5;
        this.height = n6;
    }

    public void addForceLaw(Law law) {
        this.forceLaws.add(law);
    }

    public static Particle newParticle(int n, int n2, double d) {
        Particle particle = new Particle();
        particle.setPosition(new DoublePoint(n, n2));
        particle.setCharge(d);
        return particle;
    }

    public System2D newSystem() {
        int n;
        Random random = new Random(this.seed);
        System2D system2D = new System2D();
        Vector<Particle> vector = new Vector<Particle>();
        for (int i = 0; i < this.numParticles; ++i) {
            n = random.nextInt(this.width) + this.minX;
            int n2 = random.nextInt(this.height) + this.minY;
            Particle particle = RandomSystemFactory.newParticle(n, n2, -1.0);
            system2D.addParticle(particle);
            vector.add(particle);
        }
        Particle[] particleArray = vector.toArray(new Particle[vector.size()]);
        system2D.addLaw(new ResetAcceleration());
        system2D.addLaw(new FourBounds(this.minX, this.minY, this.width, this.height, 1.2));
        for (n = 0; n < this.forceLaws.size(); ++n) {
            Law law = (Law)this.forceLaws.get(n);
            system2D.addLaw(law);
            if (!(law instanceof ParticleContainer)) continue;
            for (int i = 0; i < particleArray.length; ++i) {
                ((ParticleContainer)((Object)law)).add(particleArray[i]);
            }
        }
        system2D.addLaw(new VelocityUpdate(100.0));
        system2D.addLaw(new PositionUpdate());
        return system2D;
    }

    public void updatePanel(ParticlePanel particlePanel, System2D system2D, ParticlePainter particlePainter) {
        particlePanel.removeAll();
        particlePanel.addAll(system2D, particlePainter);
        system2D.addLaw(new RepaintLaw(particlePanel));
    }
}

