/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.efield;

import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.view.ResetAllButton;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.PiccoloClockControlPanel;
import edu.colorado.phet.efield.EFieldResources;
import edu.colorado.phet.efield.core.ParticleContainer;
import edu.colorado.phet.efield.core.RandomSystemFactory;
import edu.colorado.phet.efield.electricField.ChargeFieldSource;
import edu.colorado.phet.efield.electricField.DiscreteFieldSlider;
import edu.colorado.phet.efield.electricField.ElectricFieldPainter;
import edu.colorado.phet.efield.electricField.ElectricForceLaw;
import edu.colorado.phet.efield.electricField.FieldMenuConstructor;
import edu.colorado.phet.efield.gui.ImagePainter;
import edu.colorado.phet.efield.gui.ParticlePanel;
import edu.colorado.phet.efield.gui.WallPainter;
import edu.colorado.phet.efield.gui.addRemove.AddRemove;
import edu.colorado.phet.efield.gui.addRemove.PanelAdapter;
import edu.colorado.phet.efield.gui.addRemove.SystemAdapter;
import edu.colorado.phet.efield.gui.media.MediaControl;
import edu.colorado.phet.efield.gui.mouse.ParticleGrabber;
import edu.colorado.phet.efield.gui.mouse.ParticleThrower;
import edu.colorado.phet.efield.gui.popupMenu.ParticlePopupListener;
import edu.colorado.phet.efield.gui.vectorChooser.DefaultVectorPainter;
import edu.colorado.phet.efield.gui.vectorChooser.VectorChooser;
import edu.colorado.phet.efield.laws.CoulombsLaw;
import edu.colorado.phet.efield.laws.ForceLawAdapter;
import edu.colorado.phet.efield.particleFactory.CustomizableParticleFactory;
import edu.colorado.phet.efield.particleFactory.ShowParticlePropertyDialog;
import edu.colorado.phet.efield.phys2d_efield.DoublePoint;
import edu.colorado.phet.efield.phys2d_efield.Particle;
import edu.colorado.phet.efield.phys2d_efield.System2D;
import edu.colorado.phet.efield.phys2d_efield.SystemRunner;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class EFieldSimulationPanel
extends JPanel {
    private ElectricFieldPainter electricFieldPainter;
    private ParticlePanel particlePanel;
    private IClock clock;
    private AddRemove addRemove;
    private ParticleGrabber particleGrabber;
    private System2D system2D;
    private MediaControl mediaControl;

    public EFieldSimulationPanel(IClock iClock) {
        this.clock = iClock;
    }

    public void init() {
        int n = 0;
        int n2 = 50;
        int n3 = 50;
        int n4 = 300;
        int n5 = 300;
        ShowParticlePropertyDialog showParticlePropertyDialog = new ShowParticlePropertyDialog(1.0, -1.0);
        Particle particle = showParticlePropertyDialog.getDialog().getProperties();
        CustomizableParticleFactory customizableParticleFactory = new CustomizableParticleFactory(n2, n3, n4, n5, particle);
        showParticlePropertyDialog.getDialog().addParticlePropertyListener(customizableParticleFactory);
        RandomSystemFactory randomSystemFactory = new RandomSystemFactory(10, n, n2, n3, n4, n5);
        ElectricForceLaw electricForceLaw = new ElectricForceLaw(new DoublePoint(0.0, 0.0));
        randomSystemFactory.addForceLaw(electricForceLaw);
        CoulombsLaw coulombsLaw = new CoulombsLaw(100000.0);
        ForceLawAdapter forceLawAdapter = new ForceLawAdapter(new Particle[0], coulombsLaw);
        randomSystemFactory.addForceLaw(forceLawAdapter);
        this.system2D = randomSystemFactory.newSystem();
        final SystemRunner systemRunner = new SystemRunner(this.system2D);
        this.clock.addClockListener(new ClockAdapter(){

            public void simulationTimeChanged(ClockEvent clockEvent) {
                systemRunner.step(clockEvent.getSimulationTimeChange());
            }
        });
        this.particlePanel = new ParticlePanel();
        BufferedImage bufferedImage = EFieldResources.loadBufferedImage("electron9.gif");
        ImagePainter imagePainter = new ImagePainter(bufferedImage);
        randomSystemFactory.updatePanel(this.particlePanel, this.system2D, imagePainter);
        this.particleGrabber = new ParticleThrower(this.particlePanel, this.system2D, systemRunner, 5, 18.0);
        this.particlePanel.addMouseListener(this.particleGrabber);
        this.particlePanel.addMouseMotionListener(this.particleGrabber);
        this.setLayout(new BorderLayout());
        this.add((Component)this.particlePanel, "Center");
        this.validate();
        PiccoloClockControlPanel piccoloClockControlPanel = new PiccoloClockControlPanel(this.clock);
        ResetAllButton resetAllButton = new ResetAllButton(new Resettable(){

            public void reset() {
                EFieldSimulationPanel.this.doReset();
            }
        }, (Component)this);
        this.addRemove = new AddRemove(new Vector(), customizableParticleFactory, this.particlePanel, imagePainter);
        this.addRemove.add(new PanelAdapter(this.particlePanel, imagePainter));
        SystemAdapter systemAdapter = new SystemAdapter(this.system2D);
        this.addRemove.add(systemAdapter);
        for (int i = 0; i < this.system2D.numLaws(); ++i) {
            if (!(this.system2D.lawAt(i) instanceof ParticleContainer)) continue;
            this.addRemove.add((ParticleContainer)((Object)this.system2D.lawAt(i)));
        }
        JPanel jPanel = this.addRemove.getJPanel();
        JButton jButton = new JButton(EFieldResources.getString("FieldNode2.PropertiesButton"));
        jButton.addActionListener(showParticlePropertyDialog);
        jPanel.add(jButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(piccoloClockControlPanel);
        piccoloClockControlPanel.add(resetAllButton);
        jPanel2.add(jPanel);
        DefaultVectorPainter defaultVectorPainter = new DefaultVectorPainter(Color.blue, new BasicStroke(6.0f), 0.39269908169872414, 10.0);
        VectorChooser vectorChooser = new VectorChooser(130, 130, 1.0, 1.0, defaultVectorPainter);
        vectorChooser.addListener(electricForceLaw);
        jPanel2.add(vectorChooser);
        Border border = BorderFactory.createEtchedBorder();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, EFieldResources.getString("FieldNode2.ExternalFieldBorder"));
        vectorChooser.setBorder(titledBorder);
        this.add((Component)jPanel2, "South");
        WallPainter wallPainter = new WallPainter(n2 - 15, n3 - 15, n4 + 25, n5 + 25, new BasicStroke(8.0f, 1, 0), Color.blue);
        this.particlePanel.add(wallPainter);
        int n6 = 6;
        DefaultVectorPainter defaultVectorPainter2 = new DefaultVectorPainter(Color.blue, new BasicStroke(2.0f), 0.39269908169872414, 4.0);
        this.electricFieldPainter = new ElectricFieldPainter(n2, n3, n4, n5, n6, n6, defaultVectorPainter2);
        this.electricFieldPainter.addSource(electricForceLaw);
        int n7 = 25;
        ChargeFieldSource chargeFieldSource = new ChargeFieldSource(forceLawAdapter, 120000.0, n7);
        this.electricFieldPainter.addSource(chargeFieldSource);
        this.particlePanel.add(this.electricFieldPainter);
        FieldMenuConstructor fieldMenuConstructor = new FieldMenuConstructor(chargeFieldSource, this.particlePanel);
        ParticlePopupListener particlePopupListener = new ParticlePopupListener(this.particlePanel, fieldMenuConstructor);
        this.particlePanel.addMouseListener(particlePopupListener);
        this.mediaControl = new MediaControl(this.clock, systemRunner, randomSystemFactory, this.particlePanel, imagePainter);
        this.mediaControl.add(this.addRemove);
        this.mediaControl.add(this.particleGrabber);
    }

    private void doReset() {
        this.mediaControl.reset();
    }

    public JMenu getMenu() {
        DiscreteFieldSlider discreteFieldSlider = new DiscreteFieldSlider(this.electricFieldPainter, this.particlePanel);
        JMenuItem jMenuItem = new JMenuItem(EFieldResources.getString("FieldNode2.SetFieldDiscretenessMenuItem"));
        jMenuItem.addActionListener(discreteFieldSlider);
        JMenu jMenu = new JMenu(EFieldResources.getString("FieldNode2.ElectricFieldMenuTitle"));
        jMenu.add(jMenuItem);
        return jMenu;
    }
}

