/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.efield;

import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.view.util.FrameSetup;
import edu.colorado.phet.efield.EFieldSimulationPanel;
import javax.swing.JMenu;

public class EFieldApplication
extends PhetApplication {
    private EFieldModule module;

    public EFieldApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        this.module = new EFieldModule(phetApplicationConfig);
        this.addModule(this.module);
        this.getPhetFrame().addMenu(this.module.getMenu());
    }

    public static void main(String[] stringArray) {
        ApplicationConstructor applicationConstructor = new ApplicationConstructor(){

            public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                return new EFieldApplication(phetApplicationConfig);
            }
        };
        PhetApplicationConfig phetApplicationConfig = new PhetApplicationConfig(stringArray, "efield");
        phetApplicationConfig.setFrameSetup(new FrameSetup.CenteredWithSize(600, 600));
        new PhetApplicationLauncher().launchSim(phetApplicationConfig, applicationConstructor);
    }

    private class EFieldModule
    extends Module {
        private EFieldSimulationPanel simulationPanel;

        public EFieldModule(PhetApplicationConfig phetApplicationConfig) {
            super(phetApplicationConfig.getName(), new ConstantDtClock(35, 0.15));
            this.simulationPanel = new EFieldSimulationPanel(this.getClock());
            this.simulationPanel.init();
            this.setSimulationPanel(this.simulationPanel);
            this.setClockControlPanel(null);
            this.setLogoPanelVisible(false);
        }

        public JMenu getMenu() {
            return this.simulationPanel.getMenu();
        }
    }
}

