/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.eatingandexercise.model;

import edu.colorado.phet.common.motion.model.DefaultTemporalVariable;
import edu.colorado.phet.common.motion.model.ITemporalVariable;
import edu.colorado.phet.common.motion.model.IVariable;
import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.eatingandexercise.EatingAndExerciseResources;
import edu.colorado.phet.eatingandexercise.control.Activity;
import edu.colorado.phet.eatingandexercise.control.CaloricItem;
import edu.colorado.phet.eatingandexercise.model.CalorieSet;
import edu.colorado.phet.eatingandexercise.model.DefaultHumanUpdate;
import edu.colorado.phet.eatingandexercise.model.Diet;
import edu.colorado.phet.eatingandexercise.model.EatingAndExerciseUnits;
import edu.colorado.phet.eatingandexercise.model.HumanUpdate;
import edu.colorado.phet.eatingandexercise.module.eatingandexercise.CaloricFoodItem;
import edu.colorado.phet.eatingandexercise.module.eatingandexercise.EatingAndExerciseModel;
import edu.colorado.phet.eatingandexercise.module.eatingandexercise.FoodCalorieSet;
import java.util.ArrayList;
import java.util.Random;

public class Human {
    private String name;
    private ArrayList listeners = new ArrayList();
    private Gender gender = DEFAULT_VALUE.getGender();
    private DefaultTemporalVariable height = new DefaultTemporalVariable();
    private DefaultTemporalVariable mass = new DefaultTemporalVariable();
    private DefaultTemporalVariable age = new DefaultTemporalVariable();
    private DefaultTemporalVariable fatMassFraction = new DefaultTemporalVariable();
    private DefaultTemporalVariable lipids = new DefaultTemporalVariable();
    private DefaultTemporalVariable carbs = new DefaultTemporalVariable();
    private DefaultTemporalVariable proteins = new DefaultTemporalVariable();
    private DefaultTemporalVariable activity = new DefaultTemporalVariable();
    private DefaultTemporalVariable exercise = new DefaultTemporalVariable();
    private DefaultTemporalVariable bmr = new DefaultTemporalVariable();
    private static final ReferenceHuman REFERENCE_MALE = new ReferenceHuman(true, 22.0, 5.666666666666667, EatingAndExerciseUnits.poundsToKg(150.0), 86.0);
    private static final ReferenceHuman REFERENCE_FEMALE;
    public static final ReferenceHuman DEFAULT_VALUE;
    private CalorieSet exerciseItems = new CalorieSet();
    private FoodCalorieSet foodItems = new FoodCalorieSet();
    private double activityLevel = Activity.DEFAULT_ACTIVITY_LEVEL.getValue();
    private ITemporalVariable caloricIntakeVariable = new DefaultTemporalVariable();
    private ITemporalVariable caloricBurnVariable = new DefaultTemporalVariable();
    private CaloricFoodItem defaultIntake;
    private boolean alive = true;
    private double starvingTime = 0.0;
    private Random random = new Random();
    private int heartAttacks = 0;
    private Activity activityObject;
    private double heartStrain;
    private double heartStrength;
    private HumanUpdate humanUpdate = new DefaultHumanUpdate();

    public Human() {
        this.addListener(new Adapter(){

            public void heartHealthChanged() {
                Human.this.notifyHeartAttackProbabilityChanged();
            }
        });
        this.lipids.addListener(new IVariable.Listener(){

            public void valueChanged() {
                Human.this.notifyDietChanged();
            }
        });
        this.carbs.addListener(new IVariable.Listener(){

            public void valueChanged() {
                Human.this.notifyDietChanged();
            }
        });
        this.proteins.addListener(new IVariable.Listener(){

            public void valueChanged() {
                Human.this.notifyDietChanged();
            }
        });
        this.exercise.addListener(new IVariable.Listener(){

            public void valueChanged() {
                Human.this.notifyExerciseChanged();
            }
        });
        this.exerciseItems.addListener(new CalorieSet.Listener(){

            public void itemAdded(CaloricItem caloricItem) {
                Human.this.updateExercise();
            }

            public void itemRemoved(CaloricItem caloricItem) {
                Human.this.updateExercise();
            }

            public void itemChanged(CaloricItem caloricItem) {
                Human.this.updateExercise();
            }
        });
        this.foodItems.addListener(new CalorieSet.Listener(){

            public void itemAdded(CaloricItem caloricItem) {
                Human.this.updateIntake();
            }

            public void itemRemoved(CaloricItem caloricItem) {
                Human.this.updateIntake();
            }

            public void itemChanged(CaloricItem caloricItem) {
                Human.this.updateIntake();
            }
        });
        this.resetAll();
    }

    public void resetAll() {
        this.name = "Larry";
        this.clearTemporalVariables();
        this.setGender(DEFAULT_VALUE.getGender());
        double d = DEFAULT_VALUE.getHeightMeters();
        this.setHeight(d);
        this.setMass(DEFAULT_VALUE.getMassKG());
        this.setAge(DEFAULT_VALUE.getAgeSeconds());
        this.setFatMassPercent(100.0 - DEFAULT_VALUE.getFatFreeMassPercent());
        this.setActivityLevel(Activity.DEFAULT_ACTIVITY_LEVELS[1]);
        Diet diet = EatingAndExerciseModel.BALANCED_DIET;
        this.foodItems.clear();
        this.exerciseItems.clear();
        if (this.defaultIntake == null) {
            this.defaultIntake = new CaloricFoodItem(EatingAndExerciseResources.getString("diet.healthy"), "food-pyramid.png", diet.getFat() / 9.0, diet.getCarb() / 4.0, diet.getProtein() / 4.0, false);
        }
        this.updateIntake();
        this.simulationTimeChanged(0.0);
        this.foodItems.addListener(new CalorieSet.Listener(){

            public void itemAdded(CaloricItem caloricItem) {
                Human.this.notifyDietChanged();
            }

            public void itemRemoved(CaloricItem caloricItem) {
                Human.this.notifyDietChanged();
            }

            public void itemChanged(CaloricItem caloricItem) {
                Human.this.notifyDietChanged();
            }
        });
        this.exerciseItems.addListener(new CalorieSet.Listener(){

            public void itemAdded(CaloricItem caloricItem) {
                Human.this.exercise.setValue(Human.this.exerciseItems.getTotalCalories());
                Human.this.notifyExerciseChanged();
            }

            public void itemRemoved(CaloricItem caloricItem) {
                Human.this.exercise.setValue(Human.this.exerciseItems.getTotalCalories());
                Human.this.notifyExerciseChanged();
            }

            public void itemChanged(CaloricItem caloricItem) {
                Human.this.exercise.setValue(Human.this.exerciseItems.getTotalCalories());
                Human.this.notifyExerciseChanged();
            }
        });
        this.heartAttacks = 0;
        this.setAlive(true);
        this.starvingTime = 0.0;
        for (int i = 1; i < 100; ++i) {
            this.exercise.addValue(150.0, this.getAge() - EatingAndExerciseUnits.daysToSeconds(i));
            this.fatMassFraction.addValue(this.fatMassFraction.getValue(), this.getAge() - EatingAndExerciseUnits.daysToSeconds(i));
        }
        this.exercise.addValue(0.0, this.getAge());
        this.updateHealthIndicators();
        this.updateBMR();
    }

    public double getActivityLevel() {
        return this.activityLevel;
    }

    public ITemporalVariable getMassVariable() {
        return this.mass;
    }

    public ITemporalVariable getCaloricIntakeVariable() {
        return this.caloricIntakeVariable;
    }

    public ITemporalVariable getCaloricBurnVariable() {
        return this.caloricBurnVariable;
    }

    public CaloricFoodItem getDefaultIntake() {
        return this.defaultIntake;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void setAlive(boolean bl) {
        if (bl != this.alive) {
            this.alive = bl;
            this.notifyAliveChanged();
        }
    }

    private void notifyAliveChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).aliveChanged();
        }
    }

    private void clearTemporalVariables() {
        this.height.clear();
        this.mass.clear();
        this.age.clear();
        this.fatMassFraction.clear();
        this.lipids.clear();
        this.carbs.clear();
        this.proteins.clear();
        this.activity.clear();
        this.exercise.clear();
        this.bmr.clear();
        this.caloricIntakeVariable.clear();
        this.caloricBurnVariable.clear();
    }

    private void updateIntake() {
        this.lipids.setValue(this.foodItems.getTotalLipidCalories());
        this.carbs.setValue(this.foodItems.getTotalCarbCalories());
        this.proteins.setValue(this.foodItems.getTotalProteinCalories());
    }

    private void updateExercise() {
        this.exercise.setValue(this.exerciseItems.getTotalCalories());
    }

    public CalorieSet getSelectedFoods() {
        return this.foodItems;
    }

    public CalorieSet getSelectedExercise() {
        return this.exerciseItems;
    }

    private void notifyExerciseChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).exerciseChanged();
        }
        this.notifyCaloricBurnChanged();
    }

    private void notifyDietChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).dietChanged();
            ((Listener)this.listeners.get(i)).caloricIntakeChanged();
        }
    }

    private void updateBMR() {
        this.bmr.setValue(392.0 + 21.8 * this.getLeanBodyMass());
        this.updateActivity();
    }

    public double getFatMass() {
        return this.getFatMassPercent() / 100.0 * this.getMass();
    }

    public double getLeanBodyMass() {
        return this.getFatFreeMassPercent() / 100.0 * this.getMass();
    }

    public double getBMI() {
        return this.getMass() / Math.pow(this.getHeight(), 2.0);
    }

    private void notifyFatPercentChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).fatPercentChanged();
        }
    }

    public void setActivityLevel(Activity activity) {
        if (this.activityObject != activity) {
            this.activityObject = activity;
            this.activityLevel = activity.getValue();
            this.updateActivity();
            this.notifyActivityLevelChanged();
        }
    }

    private void notifyActivityLevelChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).activityLevelChanged();
        }
    }

    private void updateActivity() {
        this.activity.setValue(this.getActivityCaloriesPerDay());
        this.notifyActivityChanged();
    }

    public double getActivityCaloriesPerDay() {
        return this.activityLevel * this.getMass() * 20.0;
    }

    private void notifyActivityChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).activityChanged();
        }
        this.notifyCaloricBurnChanged();
    }

    private void notifyCaloricBurnChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).caloricBurnChanged();
        }
    }

    public DefaultTemporalVariable getLipids() {
        return this.lipids;
    }

    public DefaultTemporalVariable getCarbs() {
        return this.carbs;
    }

    public DefaultTemporalVariable getProteins() {
        return this.proteins;
    }

    public DefaultTemporalVariable getBmr() {
        return this.bmr;
    }

    public DefaultTemporalVariable getActivity() {
        return this.activity;
    }

    public DefaultTemporalVariable getExercise() {
        return this.exercise;
    }

    public void simulationTimeChanged(double d) {
        this.setAge(this.getAge() + d);
        this.humanUpdate.update(this, d);
        this.caloricIntakeVariable.setValue(this.getDailyCaloricIntake());
        this.caloricIntakeVariable.addValue(this.getDailyCaloricIntake(), this.getAge());
        this.caloricBurnVariable.setValue(this.getDailyCaloricBurn());
        this.caloricBurnVariable.addValue(this.getDailyCaloricBurn(), this.getAge());
        this.handleStarving(d);
        this.handleHeartAttack(d);
        this.updateHealthIndicators();
    }

    private void updateHealthIndicators() {
        this.exercise.addValue(this.exercise.getValue(), this.getAge());
        this.activity.addValue(this.activity.getValue(), this.getAge());
        this.fatMassFraction.addValue(this.fatMassFraction.getValue(), this.getAge());
        double d = this.exercise.estimateAverage(this.getAge() - EatingAndExerciseUnits.daysToSeconds(30.0), this.getAge());
        double d2 = this.activity.estimateAverage(this.getAge() - EatingAndExerciseUnits.daysToSeconds(30.0), this.getAge());
        double d3 = Math.max((d2 - 200.0) * 0.2, 0.0);
        if (d3 > 100.0) {
            d3 = 100.0;
        }
        double d4 = d + d3;
        double d5 = 1100.0;
        double d6 = this.log10(1.0 + 100.0 * d4 / d5) / this.log10(101.0);
        this.setHeartStrength(MathUtil.clamp(0.0, d6, 1.0));
        double d7 = this.fatMassFraction.estimateAverage(this.getAge() - EatingAndExerciseUnits.daysToSeconds(30.0), this.getAge()) * 100.0;
        double d8 = this.gender.getDistanceFromNormalRangeInPercent(d7);
        this.setHeartStrain(MathUtil.clamp(0.0, d8 * 2.0 / 100.0, 1.0));
    }

    private double log10(double d) {
        return Human.log(10.0, d);
    }

    public static double log(double d, double d2) {
        return Math.log(d2) / Math.log(d);
    }

    public void setHeartStrength(double d) {
        if (d != this.heartStrength) {
            this.heartStrength = d;
            this.notifyHeartStrengthChanged();
            this.notifyHeartHealthChanged();
        }
    }

    public void setHeartStrain(double d) {
        if (this.heartStrain != d) {
            this.heartStrain = d;
            this.notifyHeartStrainChanged();
            this.notifyHeartHealthChanged();
        }
    }

    private void notifyHeartHealthChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).heartHealthChanged();
        }
    }

    private void notifyHeartStrainChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).heartStrainChanged();
        }
    }

    private void notifyHeartStrengthChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).heartStrengthChanged();
        }
    }

    private void handleHeartAttack(double d) {
        double d2 = this.getHeartAttackProbabilityPerDay();
        double d3 = d2 / EatingAndExerciseUnits.daysToSeconds(1.0);
        double d4 = d3 * d;
        double d5 = this.random.nextDouble();
        if (d5 < d4) {
            this.addHeartAttack();
        }
    }

    private void handleStarving(double d) {
        this.starvingTime = this.isStarving() ? (this.starvingTime += d) : 0.0;
        if (this.getStarvingTimeDays() > 60.0 && this.isAlive()) {
            this.setAlive(false);
        }
    }

    private void addHeartAttack() {
        ++this.heartAttacks;
        this.setAlive(false);
    }

    public double getHeartAttackProbabilityPerDay() {
        return this.gender.getHeartAttackProbabilityPerDay(this);
    }

    public double getStarvingTimeDays() {
        return EatingAndExerciseUnits.secondsToDays(this.starvingTime);
    }

    public boolean isStarving() {
        return this.gender.isStarving(this);
    }

    public boolean isAlmostStarving() {
        return this.gender.isAlmostStarving(this);
    }

    public double getDeltaCaloriesGainedPerDay() {
        return this.getDailyCaloricIntake() - this.getDailyCaloricBurn();
    }

    public double getDailyCaloricBurn() {
        return this.bmr.getValue() + this.activity.getValue() + this.exercise.getValue();
    }

    public double getDailyCaloricIntake() {
        return this.lipids.getValue() + this.proteins.getValue() + this.carbs.getValue();
    }

    public double getHeartHealth() {
        return (this.getHeartStrength() + this.getHeartNonStrain()) / 2.0;
    }

    private double getHeartNonStrain() {
        return 1.0 - this.getHeartStrain();
    }

    public double getFatMassPercent() {
        return this.fatMassFraction.getValue() * 100.0;
    }

    public double getFatFreeMassPercent() {
        return 100.0 - this.getFatMassPercent();
    }

    public void setFatMassPercent(double d) {
        boolean bl = this.isStarving();
        double d2 = this.getHeartAttackProbabilityPerDay();
        this.fatMassFraction.setValue(this.gender.clampFatMassPercent(d) / 100.0);
        this.updateBMR();
        this.notifyFatPercentChanged();
        if (d2 != this.getHeartAttackProbabilityPerDay()) {
            this.notifyHeartAttackProbabilityChanged();
        }
        if (bl != this.isStarving()) {
            this.notifyStarvingChanged();
        }
    }

    private void notifyStarvingChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).starvingChanged();
        }
    }

    private void notifyHeartAttackProbabilityChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).heartAttackProbabilityChanged();
        }
    }

    public void clearMassData() {
        this.mass.clear();
    }

    public String getCauseOfDeath() {
        if (this.getStarvingTimeDays() >= 60.0) {
            return "starvation";
        }
        if (this.heartAttacks > 0) {
            return "heart attack";
        }
        return "no known cause of death";
    }

    public double getHeartStrength() {
        return this.heartStrength;
    }

    public double getHeartStrain() {
        return this.heartStrain;
    }

    public void setLeanFraction(double d) {
        this.setFatMassPercent(100.0 - d * 100.0);
    }

    public double getCaloriesExercisePerDay() {
        return this.exerciseItems.getTotalCalories();
    }

    public double getAge() {
        return this.age.getValue();
    }

    public void setAge(double d) {
        if (this.getAge() != d) {
            this.age.setValue(d);
            this.notifyAgeChanged();
        }
    }

    private void notifyAgeChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.ageChanged();
        }
    }

    public double getHeight() {
        return this.height.getValue();
    }

    public void setHeight(double d) {
        if (this.height.getValue() != d) {
            this.height.setValue(d);
            this.notifyHeightChanged();
            this.notifyBMIChanged();
        }
    }

    private void notifyBMIChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.bmiChanged();
        }
    }

    private void notifyHeightChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.heightChanged();
        }
    }

    public double getMass() {
        return this.mass.getValue();
    }

    public void setMass(double d) {
        double d2 = this.getBmr().getValue();
        this.mass.setValue(Math.max(d, 0.0));
        this.setFatMassPercent(100.0 - (d2 - 392.0) / 21.8 * (100.0 / d));
        this.notifyFatPercentChanged();
        this.notifyWeightChanged();
        this.notifyBMIChanged();
    }

    private void notifyWeightChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.weightChanged();
        }
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        if (this.gender != gender) {
            this.gender = gender;
            this.setFatMassPercent(gender.getMinFatMassPercent());
            this.setHeight(this.getReferenceHuman(gender).getHeightMeters());
            this.setMass(this.getReferenceHuman(gender).getMassKG());
            this.notifyGenderChanged();
        }
    }

    private ReferenceHuman getReferenceHuman(Gender gender) {
        if (gender == Gender.MALE) {
            return REFERENCE_MALE;
        }
        return REFERENCE_FEMALE;
    }

    private void notifyGenderChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).genderChanged();
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    static {
        DEFAULT_VALUE = REFERENCE_FEMALE = new ReferenceHuman(false, 22.0, 5.416666666666667, EatingAndExerciseUnits.poundsToKg(135.0), 74.0);
    }

    public static class Adapter
    implements Listener {
        public void bmiChanged() {
        }

        public void heightChanged() {
        }

        public void weightChanged() {
        }

        public void genderChanged() {
        }

        public void fatPercentChanged() {
        }

        public void ageChanged() {
        }

        public void dietChanged() {
        }

        public void exerciseChanged() {
        }

        public void activityChanged() {
        }

        public void caloricIntakeChanged() {
        }

        public void caloricBurnChanged() {
        }

        public void aliveChanged() {
        }

        public void heartAttackProbabilityChanged() {
        }

        public void starvingChanged() {
        }

        public void activityLevelChanged() {
        }

        public void heartStrainChanged() {
        }

        public void heartStrengthChanged() {
        }

        public void heartHealthChanged() {
        }
    }

    public static class Gender {
        public static Gender MALE = new Gender(EatingAndExerciseResources.getString("gender.male").toLowerCase(), 0.0, 100.0, 4.0, 25.0, 1.15, 4.0, 27.0, 4.0, 6.0, 25.0, 4.0, 0.25);
        public static Gender FEMALE = new Gender(EatingAndExerciseResources.getString("gender.female").toLowerCase(), 0.0, 100.0, 8.0, 32.0, 1.22, 6.0, 23.0, 9.0, 16.0, 31.0, 2.25, 0.4444444444444444);
        private String name;
        private double minFatMassPercent;
        private double maxFatMassPercent;
        private double starvingFatMassPercentThreshold;
        private double heartAttackFatMassPercentThreshold;
        public static double P0 = 0.01;
        private double LMBScaleFactor;
        private double almostStarvingUpperThreshold;
        private double stdBMI;
        private double stdPercentFat;
        private double minPercentFatRange;
        private double maxPercentFatRange;
        private double fatMassMultiplier;
        private double fatMassLimiter;

        private Gender(String string, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
            this.name = string;
            this.minFatMassPercent = d;
            this.maxFatMassPercent = d2;
            this.starvingFatMassPercentThreshold = d3;
            this.heartAttackFatMassPercentThreshold = d4;
            this.LMBScaleFactor = d5;
            this.almostStarvingUpperThreshold = d6;
            this.stdBMI = d7;
            this.stdPercentFat = d8;
            this.minPercentFatRange = d9;
            this.maxPercentFatRange = d10;
            this.fatMassMultiplier = d11;
            this.fatMassLimiter = d12;
        }

        public double getStdBMI() {
            return this.stdBMI;
        }

        public String toString() {
            return this.name;
        }

        public double getMinFatMassPercent() {
            return this.minFatMassPercent;
        }

        public double getMaxFatMassPercent() {
            return this.maxFatMassPercent;
        }

        public double clampFatMassPercent(double d) {
            return MathUtil.clamp(this.minFatMassPercent, d, this.maxFatMassPercent);
        }

        public boolean isStarving(Human human) {
            return human.getFatMassPercent() < this.starvingFatMassPercentThreshold;
        }

        public double getHeartAttackProbabilityPerDay(Human human) {
            double d = human.getHeartHealth();
            boolean bl = false;
            double d2 = 0.001;
            Function.LinearFunction linearFunction = new Function.LinearFunction(0.0, 0.35, d2, (double)bl);
            double d3 = linearFunction.evaluate(d);
            d3 = MathUtil.clamp((double)bl, d3, d2);
            return d3;
        }

        public boolean isAlmostStarving(Human human) {
            return human.getFatMassPercent() >= this.starvingFatMassPercentThreshold && human.getFatMassPercent() <= this.almostStarvingUpperThreshold;
        }

        public double getStdLeanMassFraction() {
            return 1.0 - this.stdPercentFat / 100.0;
        }

        public double getDistanceFromNormalRangeInPercent(double d) {
            if (d < this.minPercentFatRange) {
                return Math.abs(d - this.minPercentFatRange);
            }
            if (d > this.maxPercentFatRange) {
                return Math.abs(d - this.maxPercentFatRange);
            }
            return 0.0;
        }

        public double getFatMassMultiplier() {
            return this.fatMassMultiplier;
        }

        public double getFatMassLimiter() {
            return this.fatMassLimiter;
        }
    }

    public static interface Listener {
        public void bmiChanged();

        public void heightChanged();

        public void weightChanged();

        public void genderChanged();

        public void fatPercentChanged();

        public void ageChanged();

        public void dietChanged();

        public void exerciseChanged();

        public void activityChanged();

        public void caloricIntakeChanged();

        public void caloricBurnChanged();

        public void aliveChanged();

        public void heartAttackProbabilityChanged();

        public void starvingChanged();

        public void activityLevelChanged();

        public void heartStrainChanged();

        public void heartStrengthChanged();

        public void heartHealthChanged();
    }

    public static class ReferenceHuman {
        boolean male;
        double ageYears;
        double heightFT;
        double massKG;
        double fatFreeMassPercent;

        public ReferenceHuman(boolean bl, double d, double d2, double d3, double d4) {
            this.male = bl;
            this.ageYears = d;
            this.heightFT = d2;
            this.massKG = d3;
            this.fatFreeMassPercent = d4;
        }

        public double getHeightMeters() {
            return EatingAndExerciseUnits.feetToMeters(this.heightFT);
        }

        public double getAgeSeconds() {
            return EatingAndExerciseUnits.yearsToSeconds(this.ageYears);
        }

        public double getMassKG() {
            return this.massKG;
        }

        public double getFatFreeMassPercent() {
            return this.fatFreeMassPercent;
        }

        public Gender getGender() {
            return this.male ? Gender.MALE : Gender.FEMALE;
        }
    }
}

