/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.eatingandexercise.control;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolo.util.PPickPath;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;

public class TogglePClip
extends PPath {
    private boolean clipEnabled = false;

    public void setClipEnabled(boolean bl) {
        this.clipEnabled = bl;
        this.repaint();
    }

    public PBounds computeFullBounds(PBounds pBounds) {
        if (!this.clipEnabled) {
            return super.computeFullBounds(pBounds);
        }
        if (pBounds == null) {
            pBounds = new PBounds();
        }
        pBounds.reset();
        pBounds.add(this.getBoundsReference());
        this.localToParent(pBounds);
        return pBounds;
    }

    public void repaintFrom(PBounds pBounds, PNode pNode) {
        if (!this.clipEnabled) {
            super.repaintFrom(pBounds, pNode);
            return;
        }
        if (pNode != this) {
            Rectangle2D.intersect(this.getBoundsReference(), pBounds, pBounds);
            super.repaintFrom(pBounds, pNode);
        } else {
            super.repaintFrom(pBounds, pNode);
        }
    }

    protected void paint(PPaintContext pPaintContext) {
        if (!this.clipEnabled) {
            super.paint(pPaintContext);
            return;
        }
        Paint paint = this.getPaint();
        if (paint != null) {
            Graphics2D graphics2D = pPaintContext.getGraphics();
            graphics2D.setPaint(paint);
            graphics2D.fill(this.getPathReference());
        }
        pPaintContext.pushClip(this.getPathReference());
    }

    protected void paintAfterChildren(PPaintContext pPaintContext) {
        if (!this.clipEnabled) {
            super.paintAfterChildren(pPaintContext);
            return;
        }
        pPaintContext.popClip(this.getPathReference());
        if (this.getStroke() != null && this.getStrokePaint() != null) {
            Graphics2D graphics2D = pPaintContext.getGraphics();
            graphics2D.setPaint(this.getStrokePaint());
            graphics2D.setStroke(this.getStroke());
            graphics2D.draw(this.getPathReference());
        }
    }

    public boolean fullPick(PPickPath pPickPath) {
        if (!this.clipEnabled) {
            return super.fullPick(pPickPath);
        }
        if (this.getPickable() && this.fullIntersects(pPickPath.getPickBounds())) {
            pPickPath.pushNode(this);
            pPickPath.pushTransform(this.getTransformReference(false));
            if (this.pick(pPickPath)) {
                return true;
            }
            if (this.getChildrenPickable() && this.getPathReference().intersects(pPickPath.getPickBounds())) {
                int n = this.getChildrenCount();
                for (int i = n - 1; i >= 0; --i) {
                    PNode pNode = this.getChild(i);
                    if (!pNode.fullPick(pPickPath)) continue;
                    return true;
                }
            }
            if (this.pickAfterChildren(pPickPath)) {
                return true;
            }
            pPickPath.popTransform(this.getTransformReference(false));
            pPickPath.popNode(this);
        }
        return false;
    }
}

