/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.eatingandexercise.control;

import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.eatingandexercise.EatingAndExerciseResources;
import edu.colorado.phet.eatingandexercise.EatingAndExerciseStrings;
import edu.colorado.phet.eatingandexercise.control.ActivityLevelControl;
import edu.colorado.phet.eatingandexercise.control.GenderControl;
import edu.colorado.phet.eatingandexercise.control.HumanSlider;
import edu.colorado.phet.eatingandexercise.model.EatingAndExerciseUnits;
import edu.colorado.phet.eatingandexercise.model.Human;
import edu.colorado.phet.eatingandexercise.module.eatingandexercise.EatingAndExerciseCanvas;
import edu.colorado.phet.eatingandexercise.module.eatingandexercise.EatingAndExerciseModel;
import edu.colorado.phet.eatingandexercise.util.FeetInchesFormat;
import edu.colorado.phet.eatingandexercise.util.YearMonthFormat;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HumanControlPanel
extends VerticalLayoutPanel {
    private EatingAndExerciseModel model;
    private Human human;
    private ArrayList listeners = new ArrayList();
    private HumanSlider bodyFatSlider;
    private HumanSlider ageSlider;
    private HumanSlider heightSlider;
    private HumanSlider weightSlider;
    private HumanSlider p0Slider;
    private JLabel pheart;
    private ArrayList sliders = new ArrayList();

    public HumanControlPanel(EatingAndExerciseCanvas eatingAndExerciseCanvas, final EatingAndExerciseModel eatingAndExerciseModel, final Human human) {
        this.model = eatingAndExerciseModel;
        this.human = human;
        this.setFillNone();
        this.add(new GenderControl(human));
        this.setFillHorizontal();
        this.add(new ActivityLevelControl(eatingAndExerciseCanvas, human));
        this.ageSlider = new HumanSlider(0.0, 100.0, EatingAndExerciseUnits.secondsToYears(human.getAge()), EatingAndExerciseResources.getString("age"), EatingAndExerciseStrings.AGE_FORMAT.toPattern(), "");
        this.ageSlider.setTextFieldFormat(new YearMonthFormat());
        this.sliders.add(this.ageSlider);
        this.add(this.ageSlider);
        this.ageSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                human.setAge(EatingAndExerciseUnits.yearsToSeconds(HumanControlPanel.this.ageSlider.getValue()));
            }
        });
        human.addListener(new Human.Adapter(){

            public void ageChanged() {
                HumanControlPanel.this.ageSlider.setValue(EatingAndExerciseUnits.secondsToYears(human.getAge()));
            }
        });
        this.ageSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                HumanControlPanel.this.updatePercentFat();
                HumanControlPanel.this.notifyAgeManuallyChanged();
            }
        });
        double d = eatingAndExerciseModel.getUnits().modelToViewDistance(human.getHeight());
        this.heightSlider = new HumanSlider(eatingAndExerciseModel.getUnits().modelToViewDistance(1.0), eatingAndExerciseModel.getUnits().modelToViewDistance(2.72), d, EatingAndExerciseResources.getString("height"), "0.00", eatingAndExerciseModel.getUnits().getDistanceUnit());
        this.heightSlider.setTextFieldFormat(new FeetInchesFormat());
        this.heightSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                human.setHeight(eatingAndExerciseModel.getUnits().viewToModelDistance(HumanControlPanel.this.heightSlider.getValue()));
            }
        });
        this.heightSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                HumanControlPanel.this.updatePercentFat();
            }
        });
        human.addListener(new Human.Adapter(){

            public void heightChanged() {
                HumanControlPanel.this.heightSlider.setValue(eatingAndExerciseModel.getUnits().modelToViewDistance(human.getHeight()));
            }
        });
        eatingAndExerciseModel.addListener(new EatingAndExerciseModel.Adapter(){

            public void unitsChanged() {
                double d = human.getHeight();
                double d2 = eatingAndExerciseModel.getUnits().modelToViewDistance(human.getHeight());
                HumanControlPanel.this.heightSlider.setRange(eatingAndExerciseModel.getUnits().modelToViewDistance(1.0), eatingAndExerciseModel.getUnits().modelToViewDistance(2.72));
                HumanControlPanel.this.heightSlider.setValue(d2);
                HumanControlPanel.this.heightSlider.setUnits(eatingAndExerciseModel.getUnits().getDistanceUnit());
                HumanControlPanel.this.heightSlider.setPaintLabels(false);
                HumanControlPanel.this.heightSlider.setPaintTicks(false);
                human.setHeight(d);
            }
        });
        this.heightSlider.setTextFieldFormat(new FeetInchesFormat());
        eatingAndExerciseModel.addListener(new EatingAndExerciseModel.Adapter(){

            public void unitsChanged() {
                HumanControlPanel.this.heightSlider.setTextFieldFormat(eatingAndExerciseModel.getUnits() == EatingAndExerciseModel.Units.METRIC ? EatingAndExerciseStrings.AGE_FORMAT : new FeetInchesFormat());
            }
        });
        this.add(this.heightSlider);
        this.sliders.add(this.heightSlider);
        final double d2 = EatingAndExerciseUnits.poundsToKg(300.0);
        this.weightSlider = new HumanSlider(eatingAndExerciseModel.getUnits().modelToViewMass(0.0), eatingAndExerciseModel.getUnits().modelToViewMass(d2), eatingAndExerciseModel.getUnits().modelToViewMass(human.getMass()), EatingAndExerciseResources.getString("weight"), EatingAndExerciseStrings.WEIGHT_FORMAT.toPattern(), eatingAndExerciseModel.getUnits().getMassUnit());
        this.weightSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                human.setMass(eatingAndExerciseModel.getUnits().viewToModelMass(HumanControlPanel.this.weightSlider.getValue()));
            }
        });
        this.weightSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                HumanControlPanel.this.updatePercentFat();
            }
        });
        human.addListener(new Human.Adapter(){

            public void weightChanged() {
                HumanControlPanel.this.weightSlider.setValue(eatingAndExerciseModel.getUnits().modelToViewMass(human.getMass()));
            }
        });
        eatingAndExerciseModel.addListener(new EatingAndExerciseModel.Adapter(){

            public void unitsChanged() {
                HumanControlPanel.this.weightSlider.setValue(eatingAndExerciseModel.getUnits().modelToViewMass(human.getMass()));
                HumanControlPanel.this.weightSlider.setUnits(eatingAndExerciseModel.getUnits().getMassUnit());
                HumanControlPanel.this.weightSlider.setRange(eatingAndExerciseModel.getUnits().modelToViewMass(0.0), eatingAndExerciseModel.getUnits().modelToViewMass(d2));
                HumanControlPanel.this.weightSlider.setPaintLabels(false);
                HumanControlPanel.this.weightSlider.setPaintTicks(false);
            }
        });
        this.add(this.weightSlider);
        this.sliders.add(this.weightSlider);
        this.bodyFatSlider = new HumanSlider(0.0, 100.0, human.getFatMassPercent(), EatingAndExerciseResources.getString("body.fat"), "0.0", "%");
        this.bodyFatSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                human.setFatMassPercent(HumanControlPanel.this.bodyFatSlider.getValue());
            }
        });
        human.addListener(new Human.Adapter(){

            public void fatPercentChanged() {
                HumanControlPanel.this.bodyFatSlider.setValue(human.getFatMassPercent());
            }
        });
        human.addListener(new Human.Adapter(){

            public void genderChanged() {
                HumanControlPanel.this.updateBodyFatSlider();
            }
        });
        this.add(this.bodyFatSlider);
        this.sliders.add(this.bodyFatSlider);
        this.p0Slider = new HumanSlider(Math.min(0.0, Human.Gender.P0), Math.max(0.01, Human.Gender.P0), Human.Gender.P0, "p0", "0.0000", "units");
        this.p0Slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Human.Gender.P0 = HumanControlPanel.this.p0Slider.getValue();
            }
        });
        this.pheart = new JLabel();
        this.p0Slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                HumanControlPanel.this.updateHeartAttackProbabilityLabel();
            }
        });
        human.addListener(new Human.Adapter(){

            public void heartAttackProbabilityChanged() {
                HumanControlPanel.this.updateHeartAttackProbabilityLabel();
            }
        });
        this.updateHeartAttackProbabilityLabel();
        human.addListener(new Human.Adapter(){

            public void genderChanged() {
                HumanControlPanel.this.updatePercentFat();
            }

            public void activityLevelChanged() {
                HumanControlPanel.this.updatePercentFat();
            }
        });
        this.updateBodyFatSlider();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                HumanControlPanel.this.updateLayout();
            }
        });
        this.updateLayout();
    }

    private void updatePercentFat() {
        this.model.autoUpdatePercentFat();
    }

    private void updateLayout() {
        this.updateBodyFatSlider();
        this.relayoutSliders();
    }

    private void relayoutSliders() {
        HumanSlider[] humanSliderArray = this.sliders.toArray(new HumanSlider[this.sliders.size()]);
        HumanSlider.layout(humanSliderArray);
    }

    private void updateHeartAttackProbabilityLabel() {
        this.pheart.setText("probability of heart attack per day=" + new DecimalFormat("0.0000000").format(this.human.getHeartAttackProbabilityPerDay()));
    }

    public double getAgeSliderY() {
        return this.ageSlider.getY();
    }

    private void updateBodyFatSlider() {
        this.bodyFatSlider.setRange(0.0, this.human.getGender().getMaxFatMassPercent());
        Hashtable<Double, JLabel> hashtable = new Hashtable<Double, JLabel>();
        hashtable.put(new Double(10.0), new JLabel(EatingAndExerciseResources.getString("muscular")));
        hashtable.put(new Double(this.human.getGender().getMaxFatMassPercent()), new JLabel(EatingAndExerciseResources.getString("non-muscular")));
        this.bodyFatSlider.setTickLabels(hashtable);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyAgeManuallyChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).ageManuallyChanged();
        }
    }

    public static interface Listener {
        public void ageManuallyChanged();
    }
}

