/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.eatingandexercise.control;

import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.PieChartNode;
import edu.colorado.phet.eatingandexercise.EatingAndExerciseResources;
import edu.colorado.phet.eatingandexercise.control.CaloricItem;
import edu.colorado.phet.eatingandexercise.control.ICalorieSelectionPanel;
import edu.colorado.phet.eatingandexercise.control.MyVerticalLayoutPanel;
import edu.colorado.phet.eatingandexercise.model.CalorieSet;
import edu.colorado.phet.eatingandexercise.module.eatingandexercise.CaloricFoodItem;
import edu.colorado.phet.eatingandexercise.view.EatingAndExerciseColorScheme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;

public class CalorieSelectionPanel
extends JPanel
implements ICalorieSelectionPanel {
    private ArrayList listeners = new ArrayList();

    public CalorieSelectionPanel(final CalorieSet calorieSet, final CalorieSet calorieSet2, String string, String string2) {
        this.setLayout(new GridBagLayout());
        MyVerticalLayoutPanel myVerticalLayoutPanel = new MyVerticalLayoutPanel();
        int n = 0;
        while (n < calorieSet.getItemCount()) {
            DietComponent dietComponent = new DietComponent(calorieSet.getItem(n), true);
            JButton jButton = new JButton(EatingAndExerciseResources.getString("edit.add"));
            dietComponent.add(jButton);
            final int n2 = n++;
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    calorieSet2.addItem(calorieSet.getItem(n2));
                }
            });
            ((Container)myVerticalLayoutPanel).add(dietComponent);
        }
        final MyVerticalLayoutPanel myVerticalLayoutPanel2 = new MyVerticalLayoutPanel();
        for (int i = 0; i < calorieSet2.getItemCount(); ++i) {
            ((Container)myVerticalLayoutPanel2).add(new SelectedComponent(calorieSet2, calorieSet2.getItem(i)));
        }
        JScrollPane jScrollPane = new JScrollPane(myVerticalLayoutPanel);
        int n3 = 40;
        jScrollPane.getVerticalScrollBar().setUnitIncrement(n3);
        jScrollPane.setBorder(CalorieSelectionPanel.createTitledBorder(string));
        JScrollPane jScrollPane2 = new JScrollPane(myVerticalLayoutPanel2);
        jScrollPane2.getVerticalScrollBar().setUnitIncrement(n3);
        jScrollPane2.setBorder(CalorieSelectionPanel.createTitledBorder(string2));
        final JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.add(jScrollPane);
        jPanel.add(jScrollPane2);
        this.add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 1000000.0, 1000000.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        calorieSet2.addListener(new CalorieSet.Adapter(){

            public void itemAdded(CaloricItem caloricItem) {
                myVerticalLayoutPanel2.add(new SelectedComponent(calorieSet2, caloricItem));
                jPanel.invalidate();
                jPanel.revalidate();
            }

            public void itemRemoved(CaloricItem caloricItem) {
                for (int i = 0; i < myVerticalLayoutPanel2.getComponentCount(); ++i) {
                    SelectedComponent selectedComponent;
                    Component component = myVerticalLayoutPanel2.getComponent(i);
                    if (!(component instanceof SelectedComponent) || (selectedComponent = (SelectedComponent)component).item != caloricItem) continue;
                    myVerticalLayoutPanel2.remove(selectedComponent);
                    myVerticalLayoutPanel2.invalidate();
                    myVerticalLayoutPanel2.revalidate();
                    myVerticalLayoutPanel2.repaint();
                    break;
                }
            }
        });
        JButton jButton = new JButton(EatingAndExerciseResources.getString("edit.done"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CalorieSelectionPanel.this.notifyDonePressed();
            }
        });
        this.add((Component)jButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyDonePressed() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).donePressed();
        }
    }

    public static TitledBorder createTitledBorder(String string) {
        return new TitledBorder(new BevelBorder(1), string, 2, 0, new PhetFont(16, true)){

            public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                super.paintBorder(component, graphics, n, n2, n3, n4);
            }
        };
    }

    private class DietComponent
    extends JPanel {
        int maxImageW = 60;

        private DietComponent(String string, String string2) {
            Object object;
            this.setLayout(new BoxLayout(this, 0));
            int n = 0;
            if (string != null && string.trim().length() > 0) {
                object = BufferedImageUtils.multiScaleToHeight(EatingAndExerciseResources.getImage(string), 50);
                n = ((BufferedImage)object).getWidth();
                this.add(new JLabel(new ImageIcon((Image)object)));
            }
            if (this.maxImageW - n > 0) {
                this.add(Box.createHorizontalStrut(this.maxImageW - n));
            }
            object = new JLabel(string2);
            ((JComponent)object).setFont(new PhetFont(12));
            this.add((Component)object);
        }

        public DietComponent(CaloricItem caloricItem, boolean bl) {
            this(caloricItem.getImage(), caloricItem.getLabelText());
            if (bl && caloricItem instanceof CaloricFoodItem) {
                this.showPieChart((CaloricFoodItem)caloricItem);
            }
        }

        protected void showPieChart(CaloricFoodItem caloricFoodItem) {
            PhetPCanvas phetPCanvas = new PhetPCanvas();
            phetPCanvas.setPreferredSize(new Dimension(50, 50));
            phetPCanvas.addScreenChild(new PieChartNode(new PieChartNode.PieValue[]{new PieChartNode.PieValue(caloricFoodItem.getCarbCalories(), EatingAndExerciseColorScheme.CARBS), new PieChartNode.PieValue(caloricFoodItem.getProteinCalories(), EatingAndExerciseColorScheme.PROTEIN), new PieChartNode.PieValue(caloricFoodItem.getLipidCalories(), EatingAndExerciseColorScheme.FATS)}, new Rectangle(5, 5, 40, 40)));
            phetPCanvas.setOpaque(false);
            phetPCanvas.setBackground(new Color(0, 0, 0, 0));
            phetPCanvas.setBorder(null);
            this.add(phetPCanvas);
        }
    }

    public static interface Listener {
        public void donePressed();
    }

    private class SelectedComponent
    extends DietComponent {
        private CalorieSet set;
        private CaloricItem item;

        public SelectedComponent(final CalorieSet calorieSet, final CaloricItem caloricItem) {
            boolean bl;
            super(caloricItem, false);
            this.set = calorieSet;
            this.item = caloricItem;
            boolean bl2 = bl = caloricItem instanceof CaloricFoodItem && ((CaloricFoodItem)caloricItem).isRemovable();
            if (bl || !(caloricItem instanceof CaloricFoodItem)) {
                JButton jButton = new JButton(EatingAndExerciseResources.getString("edit.remove"));
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        calorieSet.removeItem(caloricItem);
                    }
                });
                this.add(jButton);
            }
        }
    }
}

