/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.conductivity.oldphetgraphics;

import edu.colorado.phet.conductivity.oldphetgraphics.Graphic;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;

public class ShapeGraphic
implements Graphic {
    private Shape shape;
    private Paint outlinePaint;
    private Paint fillPaint;
    private Stroke outlineStroke;

    public ShapeGraphic(Shape shape, Paint paint) {
        this(shape, paint, null, null);
    }

    public ShapeGraphic(Shape shape, Paint paint, Stroke stroke) {
        this(shape, null, paint, stroke);
    }

    public ShapeGraphic(Shape shape, Paint paint, Paint paint2, Stroke stroke) {
        this.shape = shape;
        this.fillPaint = paint;
        this.outlinePaint = paint2;
        this.outlineStroke = stroke;
    }

    public void paint(Graphics2D graphics2D) {
        Stroke stroke = graphics2D.getStroke();
        if (this.fillPaint != null) {
            graphics2D.setPaint(this.fillPaint);
            graphics2D.fill(this.shape);
        }
        if (this.outlineStroke != null) {
            graphics2D.setPaint(this.outlinePaint);
            graphics2D.setStroke(this.outlineStroke);
            graphics2D.draw(this.shape);
        }
        graphics2D.setStroke(stroke);
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public void setOutlinePaint(Paint paint) {
        this.outlinePaint = paint;
    }

    public void setFillPaint(Paint paint) {
        this.fillPaint = paint;
    }
}

