/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.conductivity.oldphetgraphics;

import edu.colorado.phet.common.phetcommon.util.MultiMap;
import edu.colorado.phet.conductivity.oldphetgraphics.Boundary;
import edu.colorado.phet.conductivity.oldphetgraphics.Graphic;
import edu.colorado.phet.conductivity.oldphetgraphics.InteractiveGraphic;
import edu.colorado.phet.conductivity.oldphetgraphics.MouseManager;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.Iterator;

public class CompositeInteractiveGraphic
implements InteractiveGraphic {
    MultiMap graphicMap = new MultiMap();
    MouseManager mouseManager = new MouseManager(this.graphicMap);

    public void paint(Graphics2D graphics2D) {
        Iterator iterator = this.graphicMap.iterator();
        while (iterator.hasNext()) {
            Graphic graphic = (Graphic)iterator.next();
            graphic.paint(graphics2D);
        }
    }

    public boolean contains(int n, int n2) {
        Iterator iterator = this.graphicMap.iterator();
        while (iterator.hasNext()) {
            Boundary boundary;
            Object e = iterator.next();
            if (!(e instanceof Boundary) || !(boundary = (Boundary)e).contains(n, n2)) continue;
            return true;
        }
        return false;
    }

    public void remove(Graphic graphic) {
        this.graphicMap.removeValue(graphic);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.mouseManager.mouseClicked(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseManager.mousePressed(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseManager.mouseReleased(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseManager.mouseEntered(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseManager.mouseExited(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseManager.mouseDragged(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouseManager.mouseMoved(mouseEvent);
    }

    public void addGraphic(Graphic graphic, double d) {
        this.graphicMap.put(new Double(d), graphic);
    }
}

