/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.conductivity.macro.particles;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.util.SimpleObservable;
import edu.colorado.phet.conductivity.macro.circuit.Circuit;

public class WireParticle
extends SimpleObservable
implements ModelElement {
    double dist;
    Circuit circuit;
    private double speed = 0.0;

    public WireParticle(double d, Circuit circuit) {
        this.dist = d;
        this.circuit = circuit;
    }

    public void setPosition(double d) {
        this.dist = d;
        this.notifyObservers();
    }

    public ImmutableVector2D getPosition() {
        return this.circuit.getPosition(this.dist);
    }

    public void stepInTime(double d) {
        double d2 = this.dist + this.speed * d;
        if (this.circuit.contains(d2)) {
            this.setPosition(d2);
        } else {
            double d3 = this.circuit.getLength();
            while (d2 < 0.0) {
                d2 += d3;
            }
            while (d2 > d3) {
                d2 -= d3;
            }
            this.setPosition(d2);
        }
    }

    public void setSpeed(double d) {
        this.speed = d;
    }
}

