/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.conductivity.macro.circuit;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.TransformListener;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.conductivity.common.StretchedBufferedImage;
import edu.colorado.phet.conductivity.macro.battery.Battery;
import edu.colorado.phet.conductivity.macro.circuit.LinearBranch;
import edu.colorado.phet.conductivity.macro.circuit.MacroCircuit;
import edu.colorado.phet.conductivity.macro.circuit.Resistor;
import edu.colorado.phet.conductivity.macro.circuit.Wire;
import edu.colorado.phet.conductivity.oldphetgraphics.Graphic;
import edu.colorado.phet.conductivity.oldphetgraphics.ShapeGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;

public class MacroCircuitGraphic {
    private MacroCircuit circuit;
    private ModelViewTransform2D transform;
    ArrayList wireGraphics = new ArrayList();
    ShapeGraphic resistorGraphic;
    StretchedBufferedImage battGraphic;
    private BufferedImage batteryImage;
    private static BufferedImage particleImage;
    private static ImageLoader loader;

    public MacroCircuitGraphic(MacroCircuit macroCircuit, ModelViewTransform2D modelViewTransform2D) throws IOException {
        this.circuit = macroCircuit;
        this.transform = modelViewTransform2D;
        this.init();
    }

    void init() throws IOException {
        for (int i = 0; i < this.circuit.numBranches(); ++i) {
            Object object;
            Object object2;
            final LinearBranch linearBranch = this.circuit.wireAt(i);
            if (linearBranch instanceof Wire) {
                object2 = new Line2D.Double(linearBranch.getStartPosition().toPoint2D(), linearBranch.getEndPosition().toPoint2D());
                object = new Color(240, 130, 150);
                ShapeGraphic shapeGraphic = new ShapeGraphic((Shape)object2, (Paint)object, new BasicStroke(MacroCircuitGraphic.getParticleImage().getWidth() + 4));
                this.wireGraphics.add(shapeGraphic);
                Object object3 = object2;
                this.transform.addTransformListener(new TransformListener((Line2D.Double)object3, shapeGraphic){
                    final /* synthetic */ Line2D.Double val$sh1;
                    final /* synthetic */ ShapeGraphic val$sg;
                    {
                        this.val$sh1 = double_;
                        this.val$sg = shapeGraphic;
                    }

                    public void transformChanged(ModelViewTransform2D modelViewTransform2D) {
                        Shape shape = MacroCircuitGraphic.this.transform.getAffineTransform().createTransformedShape(this.val$sh1);
                        this.val$sg.setShape(shape);
                    }
                });
                continue;
            }
            if (linearBranch instanceof Resistor) {
                object2 = new Line2D.Double(linearBranch.getStartPosition().toPoint2D(), linearBranch.getEndPosition().toPoint2D());
                this.resistorGraphic = new ShapeGraphic((Shape)object2, Color.yellow, new BasicStroke(MacroCircuitGraphic.getParticleImage().getWidth() * 4));
                object = object2;
                this.transform.addTransformListener(new TransformListener((Line2D.Double)object){
                    final /* synthetic */ Line2D.Double val$sh1;
                    {
                        this.val$sh1 = double_;
                    }

                    public void transformChanged(ModelViewTransform2D modelViewTransform2D) {
                        Shape shape = MacroCircuitGraphic.this.transform.getAffineTransform().createTransformedShape(this.val$sh1);
                        MacroCircuitGraphic.this.resistorGraphic.setShape(shape);
                    }
                });
                continue;
            }
            if (!(linearBranch instanceof Battery)) continue;
            object2 = this.getBatteryImage();
            this.battGraphic = object = new StretchedBufferedImage((BufferedImage)object2, new Rectangle(0, 0, 100, 100));
            this.transform.addTransformListener(new TransformListener((StretchedBufferedImage)object){
                final /* synthetic */ StretchedBufferedImage val$sbi;
                {
                    this.val$sbi = stretchedBufferedImage;
                }

                public void transformChanged(ModelViewTransform2D modelViewTransform2D) {
                    Vector2D vector2D = linearBranch.getEndPosition();
                    Vector2D vector2D2 = linearBranch.getStartPosition();
                    int n = (int)((double)MacroCircuitGraphic.this.batteryImage.getHeight() * 0.8);
                    int n2 = MacroCircuitGraphic.this.transform.modelToViewX(vector2D.getX());
                    int n3 = MacroCircuitGraphic.this.transform.modelToViewX(vector2D2.getX()) - n2;
                    int n4 = MacroCircuitGraphic.this.transform.modelToViewY(vector2D.getY());
                    Rectangle rectangle = new Rectangle(n2, n4 - n / 2, n3, n);
                    this.val$sbi.setOutputRect(rectangle);
                }
            });
        }
    }

    private BufferedImage getBatteryImage() throws IOException {
        if (this.batteryImage != null) {
            return this.batteryImage;
        }
        loader.setPhetLoader();
        this.batteryImage = ImageLoader.loadBufferedImage("conductivity/images/battery.png");
        return this.batteryImage;
    }

    public static BufferedImage getParticleImage() throws IOException {
        if (particleImage != null) {
            return particleImage;
        }
        loader.setPhetLoader();
        ImageLoader imageLoader = loader;
        particleImage = ImageLoader.loadBufferedImage("conductivity/images/particle-blue-sml.gif");
        return particleImage;
    }

    public int numWireGraphics() {
        return this.wireGraphics.size();
    }

    public Graphic wireGraphicAt(int n) {
        return (Graphic)this.wireGraphics.get(n);
    }

    public ShapeGraphic getResistorGraphic() {
        return this.resistorGraphic;
    }

    public StretchedBufferedImage getBatteryGraphic() {
        return this.battGraphic;
    }

    static {
        loader = new ImageLoader();
    }
}

