/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.conductivity.macro.circuit;

import edu.colorado.phet.conductivity.macro.battery.Battery;
import edu.colorado.phet.conductivity.macro.circuit.Circuit;
import edu.colorado.phet.conductivity.macro.circuit.Resistor;

public class MacroCircuit
extends Circuit {
    static double x = 0.31;
    static double xmax = 0.9;
    static double y = 0.4;
    private Resistor resistor;
    private Battery battery;

    public MacroCircuit() {
        super(x, y);
        double d = xmax - x;
        double d2 = d * 0.8;
        double d3 = (d - d2) / 2.0;
        this.wireTo(x + d3, y);
        this.resistor = this.resistorTo(x + d3 + d2, y);
        this.wireTo(xmax, y);
        this.wireTo(xmax, 0.9);
        this.wireTo(0.65, 0.9);
        this.battery = this.batteryTo(0.5, 0.9);
        this.wireTo(x, 0.9);
        this.wireTo(x, y);
    }

    public Resistor getResistor() {
        return this.resistor;
    }

    public Battery getBattery() {
        return this.battery;
    }
}

