/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.conductivity.macro.circuit;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.conductivity.macro.circuit.LinearBranch;
import java.util.ArrayList;

public class CompositeLinearBranch {
    ArrayList branches = new ArrayList();

    public void addBranch(LinearBranch linearBranch) {
        this.branches.add(linearBranch);
    }

    public double getLength() {
        double d = 0.0;
        for (int i = 0; i < this.branches.size(); ++i) {
            LinearBranch linearBranch = (LinearBranch)this.branches.get(i);
            d += linearBranch.getLength();
        }
        return d;
    }

    public ImmutableVector2D getPosition(double d) {
        double d2 = 0.0;
        for (int i = 0; i < this.branches.size(); ++i) {
            LinearBranch linearBranch = (LinearBranch)this.branches.get(i);
            if (linearBranch.getLength() + d2 >= d) {
                double d3 = d - d2;
                return linearBranch.getLocation(d3);
            }
            d2 += linearBranch.getLength();
        }
        return null;
    }

    public LinearBranch branchAt(int n) {
        return (LinearBranch)this.branches.get(n);
    }

    public int numBranches() {
        return this.branches.size();
    }
}

