/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.conductivity.macro.battery;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.conductivity.ConductivityApplication;
import edu.colorado.phet.conductivity.ConductivityResources;
import edu.colorado.phet.conductivity.macro.battery.Battery;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BatterySpinner {
    private JSpinner spinner;
    private double min;
    private double max;
    private Battery battery;
    private ConductivityApplication conductivityApplication;

    public BatterySpinner(final Battery battery, ConductivityApplication conductivityApplication) {
        Serializable serializable;
        this.battery = battery;
        this.conductivityApplication = conductivityApplication;
        this.min = 0.0;
        this.max = 2.0;
        this.spinner = new JSpinner(new SpinnerNumberModel(battery.getVoltage(), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.1));
        if (this.spinner.getEditor() instanceof JSpinner.DefaultEditor) {
            serializable = (JSpinner.DefaultEditor)this.spinner.getEditor();
            ((JSpinner.DefaultEditor)serializable).getTextField().addKeyListener(new KeyAdapter((JSpinner.DefaultEditor)serializable, battery){
                final /* synthetic */ JSpinner.DefaultEditor val$ed;
                final /* synthetic */ Battery val$battery;
                {
                    this.val$ed = defaultEditor;
                    this.val$battery = battery;
                }

                public void keyReleased(KeyEvent keyEvent) {
                    String string = this.val$ed.getTextField().getText();
                    try {
                        double d = Double.parseDouble(string);
                        if (d >= BatterySpinner.this.min && d <= BatterySpinner.this.max) {
                            this.val$battery.setVoltage(d);
                        } else {
                            BatterySpinner.this.handleErrorInput();
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
        }
        serializable = BorderFactory.createTitledBorder(ConductivityResources.getString("BatterySpinner.BorderTitle"));
        ((TitledBorder)serializable).setTitleFont(new PhetFont(1, 12));
        this.spinner.setBorder((Border)((Object)serializable));
        this.spinner.setPreferredSize(new Dimension(150, this.spinner.getPreferredSize().height));
        this.spinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                double d = BatterySpinner.this.getSpinnerValue();
                if (d >= BatterySpinner.this.min && d <= BatterySpinner.this.max) {
                    battery.setVoltage(d);
                } else {
                    BatterySpinner.this.spinner.setValue(new Double(battery.getVoltage()));
                }
            }
        });
    }

    private void handleErrorInput() {
        this.conductivityApplication.stopClock();
        PhetOptionPane.showErrorDialog(this.spinner, "Value out of range: Voltage should be betwen 0 and 2 Volts.");
        this.conductivityApplication.startClock();
        this.spinner.setValue(new Double(this.battery.getVoltage()));
        if (this.spinner.getEditor() instanceof JSpinner.DefaultEditor) {
            JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)this.spinner.getEditor();
            defaultEditor.getTextField().setText(this.battery.getVoltage() + "");
        }
    }

    private double getSpinnerValue() {
        Object object = this.spinner.getValue();
        Double d = (Double)object;
        return d;
    }

    public JSpinner getSpinner() {
        return this.spinner;
    }
}

