/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.conductivity.macro.bands.states;

import edu.colorado.phet.conductivity.macro.bands.BandParticle;
import edu.colorado.phet.conductivity.macro.bands.BandParticleState;
import edu.colorado.phet.conductivity.macro.bands.EnergyCell;
import edu.colorado.phet.conductivity.macro.bands.EnergyLevel;
import edu.colorado.phet.conductivity.macro.bands.PhotoconductorBandSet;
import edu.colorado.phet.conductivity.macro.bands.states.MoveTo;
import edu.colorado.phet.conductivity.macro.bands.states.Speed;
import java.util.Random;

public class Waiting
implements BandParticleState {
    private Random random = new Random(0L);

    public BandParticleState stepInTime(final BandParticle bandParticle, double d) {
        EnergyCell energyCell;
        EnergyLevel energyLevel;
        int n = bandParticle.getEnergyLevel().indexOf(bandParticle);
        if (n == -1) {
            return this;
        }
        double d2 = bandParticle.getEnergyLevel().getBand().getVoltage();
        if (d2 == 0.0 && (bandParticle.getEnergyLevel().canConduct() && !this.isPhotoConductor(bandParticle) || this.canPhotoFall(bandParticle)) && (energyLevel = bandParticle.getEnergyLevel().getBand().getBandSet().getLowerLevel(bandParticle.getEnergyLevel())) != null) {
            energyCell = energyLevel.cellAt(n);
            boolean bl = energyCell.isOccupied();
            if (bandParticle.getEnergyLevel().getBand() == energyLevel.getBand()) {
                // empty if block
            }
            if (!bl) {
                return bandParticle.moveTo(energyCell, new Speed(){

                    public double getSpeed() {
                        return 0.0078000000000000005;
                    }
                });
            }
        }
        if (d2 == 0.0) {
            return this;
        }
        int n2 = n - 1;
        if (n2 == -1) {
            n2 = 1;
        }
        if (!(energyCell = bandParticle.getEnergyLevel().cellAt(n2)).hasOwner() && bandParticle.getEnergyLevel().canConduct() && this.random.nextInt(100) <= 100) {
            MoveTo moveTo = bandParticle.moveTo(energyCell, new Speed(){

                public double getSpeed() {
                    return Math.abs(bandParticle.getEnergyLevel().getBand().getSpeed());
                }
            });
            moveTo.stepInTime(bandParticle, d);
            return moveTo;
        }
        return this;
    }

    private boolean canPhotoFall(BandParticle bandParticle) {
        if (!this.isPhotoConductor(bandParticle)) {
            return false;
        }
        PhotoconductorBandSet photoconductorBandSet = (PhotoconductorBandSet)bandParticle.getEnergyLevel().getBand().getBandSet();
        return !photoconductorBandSet.isLightOn();
    }

    private boolean isPhotoConductor(BandParticle bandParticle) {
        return bandParticle.getEnergyLevel().getBand().getBandSet() instanceof PhotoconductorBandSet;
    }
}

