/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.conductivity.macro.bands.states;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.conductivity.macro.bands.BandParticle;
import edu.colorado.phet.conductivity.macro.bands.BandParticleState;
import edu.colorado.phet.conductivity.macro.bands.EnergyCell;
import edu.colorado.phet.conductivity.macro.bands.states.Speed;
import edu.colorado.phet.conductivity.macro.bands.states.Waiting;

public class MoveTo
implements BandParticleState {
    private EnergyCell target;
    Speed speed;

    public MoveTo(EnergyCell energyCell, Speed speed) {
        this.target = energyCell;
        this.speed = speed;
    }

    public BandParticleState stepInTime(BandParticle bandParticle, double d) {
        Vector2D vector2D;
        double d2 = 0.0;
        if (bandParticle.getX() < bandParticle.getEnergyLevel().getLine().getX1() - d2) {
            bandParticle.setX(bandParticle.getEnergyLevel().getLine().getX2() + d2);
        }
        double d3 = this.speed.getSpeed() * d;
        Vector2D vector2D2 = this.target.getPosition();
        ImmutableVector2D immutableVector2D = vector2D2.getSubtractedInstance(vector2D = bandParticle.getPosition());
        double d4 = immutableVector2D.getMagnitude();
        if (d4 <= d3) {
            bandParticle.setPosition(vector2D2);
            return new Waiting();
        }
        ImmutableVector2D immutableVector2D2 = immutableVector2D.getInstanceOfMagnitude(d3);
        immutableVector2D2 = new Vector2D(-Math.abs(immutableVector2D2.getX()), immutableVector2D2.getY());
        ImmutableVector2D immutableVector2D3 = vector2D.getAddedInstance(immutableVector2D2);
        bandParticle.setPosition(new Vector2D(immutableVector2D3.getX(), immutableVector2D3.getY()));
        return this;
    }
}

