/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.conductivity.macro.bands;

import edu.colorado.phet.conductivity.macro.MacroSystem;
import edu.colorado.phet.conductivity.macro.bands.Band;
import edu.colorado.phet.conductivity.macro.bands.DefaultBandSet;
import edu.colorado.phet.conductivity.macro.bands.EnergyLevel;
import java.util.Random;

public class PhotoconductorBandSet
extends DefaultBandSet {
    boolean lightOn;
    int excitedCount;
    private MacroSystem macrosystem;

    public PhotoconductorBandSet(MacroSystem macroSystem, double d) {
        super(macroSystem, d);
        this.macrosystem = macroSystem;
        this.lightOn = false;
        this.random = new Random(0L);
        this.excitedCount = 0;
        double d2 = d;
        double d3 = d2 * 1.2;
        double d4 = 0.14 + this.inset * 2.0;
        int n = (int)(d4 / d3);
        double d5 = d2 * 0.51;
        this.upper.addLevels(0.5, 0.7, this.highBandNumLevels, 0.1 - this.inset, d4, n, d5, 0.03333333333333333);
        this.lowband.addLevels(this.lowBandY1, this.lowBandY2, this.lowNumLevels, 0.1 - this.inset, d4, n, d5, 0.03333333333333333);
        this.setConducting(false);
    }

    public void stepInTime(double d) {
        super.stepInTime(d);
        this.macrosystem.doVoltageChanged();
        if (!this.lightOn) {
            this.excitedCount = 0;
            this.moveDown();
            this.moveParticle(this.getUpperBand(2), this.getUpperBand(1), false);
            this.moveParticle(this.getUpperBand(1), this.getUpperBand(0), false);
            this.moveParticle(this.getUpperBand(0), this.getLowBandFromTop(0), false);
            this.moveParticle(this.getLowBandFromTop(0), this.getLowBandFromTop(1), false);
            this.moveParticle(this.getLowBandFromTop(1), this.getLowBandFromTop(2), false);
            this.moveParticle(this.getLowBandFromTop(2), this.getLowBandFromTop(3), false);
        }
    }

    public void initParticles() {
        super.initParticles();
        for (int i = 0; i < this.getLowerBand().numEnergyLevels(); ++i) {
            super.fillLevel(this.getLowerBand().energyLevelAt(i));
        }
    }

    public double desiredSpeedToActualSpeed(double d) {
        int n = this.getUpperBand().numParticles();
        if (n == 0) {
            return 0.0;
        }
        return super.desiredSpeedToActualSpeed(d);
    }

    public void photonHit() {
        if (!this.lightOn) {
            return;
        }
        this.moveUp();
        this.setConducting(true);
        super.photonGotAbsorbed();
    }

    private EnergyLevel getUpperBand(int n) {
        return this.upper.energyLevelAt(n);
    }

    private EnergyLevel getLowBandFromTop(int n) {
        return this.lowband.energyLevelAt(this.lowband.numEnergyLevels() - 1 - n);
    }

    private void moveDown() {
        this.setConducting(false);
        this.moveParticle(this.getLowBandFromTop(0), this.getUpperBand(1), true);
        this.moveParticle(this.getLowBandFromTop(1), this.getUpperBand(0), true);
    }

    private void moveUp() {
        this.moveParticle(this.getLowBandFromTop(0), this.getUpperBand(1));
        this.moveParticle(this.getLowBandFromTop(1), this.getUpperBand(0));
    }

    private void setConducting(boolean bl) {
        this.getLowBandFromTop(0).setCanConduct(bl);
        this.getLowBandFromTop(1).setCanConduct(bl);
        this.getUpperBand(0).setCanConduct(bl);
        this.getUpperBand(1).setCanConduct(bl);
    }

    public boolean isLightOn() {
        return this.lightOn;
    }

    public void setFlashlightOn(boolean bl) {
        this.lightOn = bl;
        if (!this.lightOn) {
            this.excitedCount = 0;
            this.moveDown();
        }
    }

    public int getFermiLevel() {
        return super.getLowerBand().numEnergyLevels() / 2;
    }

    public double voltageChanged(double d, double d2) {
        if (this.lightOn && this.particlesElevated()) {
            if (d == 0.0) {
                this.setConductionCount(0, 0);
            } else if (d > 0.0 && d <= 0.5) {
                this.setConductionCount(1, 0);
            } else if (d > 0.5 & d <= 1.0) {
                this.setConductionCount(1, 1);
            } else if (d > 1.0 && d <= 1.5) {
                this.setConductionCount(2, 1);
            } else if (d > 1.5 && d <= 2.0) {
                this.setConductionCount(2, 2);
            }
        } else {
            this.setConductionCount(0, 0);
        }
        return super.voltageChanged(d, d2);
    }

    private boolean particlesElevated() {
        return this.getUpperBand(0).isFull() && this.getUpperBand(1).isFull();
    }

    private void setConductionCount(int n, int n2) {
        int n3 = this.getFermiLevel();
        Band band = this.getLowerBand();
        EnergyLevel energyLevel = band.energyLevelAt(n3 + 1);
        EnergyLevel energyLevel2 = band.energyLevelAt(n3 + 2);
        this.moveParticles(energyLevel, n);
        this.moveParticles(energyLevel2, n2);
    }

    EnergyLevel getDonorLevel() {
        int n;
        for (int i = n = this.getFermiLevel(); i >= 0; --i) {
            if (this.lowband.energyLevelAt(i).numParticles() <= 0) continue;
            return this.lowband.energyLevelAt(i);
        }
        return null;
    }

    EnergyLevel getAcceptor() {
        int n;
        for (int i = n = this.getFermiLevel(); i >= 0; --i) {
            if (this.lowband.energyLevelAt(i).numParticles() >= 2) continue;
            return this.lowband.energyLevelAt(i);
        }
        return null;
    }

    protected void moveParticles(EnergyLevel energyLevel, int n) {
        EnergyLevel energyLevel2;
        int n2 = 0;
        while (energyLevel.numParticles() > n && (energyLevel2 = this.getAcceptor()) != null) {
            this.moveParticle(energyLevel, energyLevel2);
            if (++n2 <= 100) continue;
            throw new RuntimeException("Loop broke.");
        }
        while (energyLevel.numParticles() < n && (energyLevel2 = this.getDonorLevel()) != null) {
            this.moveParticle(energyLevel2, energyLevel);
            if (++n2 <= 100) continue;
            throw new RuntimeException("Loop broke.");
        }
    }
}

