/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.conductivity.macro.bands;

import edu.colorado.phet.conductivity.macro.MacroSystem;
import edu.colorado.phet.conductivity.macro.bands.DefaultBandSet;

public class InsulatorBandSet
extends DefaultBandSet {
    public InsulatorBandSet(MacroSystem macroSystem, double d) {
        super(macroSystem, d);
        double d2 = d;
        double d3 = d2 * 1.2;
        double d4 = 0.14 + this.inset * 2.0;
        int n = (int)(d4 / d3);
        double d5 = d2 * 0.51;
        this.upper.addLevels(0.7, 0.9, this.highBandNumLevels, 0.1 - this.inset, d4, n, d5, 0.03333333333333333);
        this.lowband.addLevels(this.lowBandY1, this.lowBandY2, this.lowNumLevels, 0.1 - this.inset, d4, n, d5, 0.03333333333333333);
    }

    public void initParticles() {
        super.initParticles();
        for (int i = 0; i < this.getFermiLevel(); ++i) {
            super.fillLevel(this.getLowerBand().energyLevelAt(i));
        }
    }

    public int getFermiLevel() {
        int n = super.getLowerBand().numEnergyLevels();
        return n;
    }

    public double desiredSpeedToActualSpeed(double d) {
        return 0.0;
    }

    public double voltageChanged(double d, double d2) {
        return super.voltageChanged(d, d2);
    }
}

