/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.conductivity.macro.bands;

import edu.colorado.phet.conductivity.macro.bands.Band;
import edu.colorado.phet.conductivity.macro.bands.BandParticle;
import edu.colorado.phet.conductivity.macro.bands.EnergyCell;
import edu.colorado.phet.conductivity.macro.bands.states.Speed;
import java.awt.geom.Line2D;
import java.util.ArrayList;

public class EnergyLevel {
    private Band band;
    double x;
    double y;
    double width;
    ArrayList cells = new ArrayList();
    private boolean canConduct = false;

    public EnergyLevel(Band band, double d, double d2, double d3, int n, double d4) {
        this.band = band;
        this.x = d;
        this.y = d2;
        this.width = d3;
        double d5 = d3 / 3.0;
        EnergyCell energyCell = new EnergyCell(this, d + d5, d2 + d4);
        EnergyCell energyCell2 = new EnergyCell(this, d + d3 - d5, d2 + d4);
        this.cells.add(energyCell);
        this.cells.add(energyCell2);
    }

    public int numCells() {
        return this.cells.size();
    }

    public String toString() {
        return "index=" + this.band.indexOf(this);
    }

    public Line2D.Double getLine() {
        return new Line2D.Double(this.x, this.y, this.x + this.width, this.y);
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public EnergyCell cellAt(int n) {
        return (EnergyCell)this.cells.get(n);
    }

    public void setCanConduct(boolean bl) {
        this.canConduct = bl;
    }

    public int numParticles() {
        int n = 0;
        for (int i = 0; i < this.cells.size(); ++i) {
            EnergyCell energyCell = (EnergyCell)this.cells.get(i);
            if (!energyCell.hasOwner()) continue;
            ++n;
        }
        return n;
    }

    public int indexOf(EnergyCell energyCell) {
        return this.cells.indexOf(energyCell);
    }

    public int indexOf(BandParticle bandParticle) {
        for (int i = 0; i < this.cells.size(); ++i) {
            EnergyCell energyCell = (EnergyCell)this.cells.get(i);
            if (energyCell.getOwner() != bandParticle) continue;
            return i;
        }
        return -1;
    }

    public Band getBand() {
        return this.band;
    }

    public boolean isFull() {
        return this.numParticles() == 2;
    }

    public boolean hasAnEmptyCell() {
        return this.numParticles() <= 1;
    }

    public BandParticle[] fillLevel() {
        BandParticle bandParticle = new BandParticle(0.0, 0.0, this.cellAt(0));
        BandParticle bandParticle2 = new BandParticle(0.0, 0.0, this.cellAt(1));
        bandParticle.setPosition(this.cellAt(0).getPosition());
        bandParticle2.setPosition(this.cellAt(1).getPosition());
        return new BandParticle[]{bandParticle, bandParticle2};
    }

    public boolean canConduct() {
        return this.canConduct;
    }

    public void propagateBoth(Speed speed) {
        BandParticle bandParticle = this.cellAt(0).getOwner();
        BandParticle bandParticle2 = this.cellAt(1).getOwner();
        bandParticle.pairPropagate(bandParticle2, speed);
    }
}

