/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.conductivity.macro.bands;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.conductivity.macro.bands.BandParticle;
import edu.colorado.phet.conductivity.macro.bands.EnergyLevel;

public class EnergyCell {
    double x;
    double y;
    BandParticle owner;
    EnergyLevel level;

    public EnergyCell(EnergyLevel energyLevel, double d, double d2) {
        this.level = energyLevel;
        this.x = d;
        this.y = d2;
    }

    public String toString() {
        return "Band=" + this.level.getBand() + ", level=" + this.level + ", index=" + this.level.indexOf(this);
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public BandParticle getOwner() {
        return this.owner;
    }

    public void setOwner(BandParticle bandParticle) {
        if (this.owner != null && this.owner != bandParticle) {
            throw new RuntimeException("Wrong owner.");
        }
        this.owner = bandParticle;
    }

    public void detach(BandParticle bandParticle) {
        if (this.owner != bandParticle) {
            throw new RuntimeException("Only owner can detach.");
        }
        this.owner = null;
    }

    public Vector2D getPosition() {
        return new Vector2D(this.x, this.y);
    }

    public EnergyLevel getEnergyLevel() {
        return this.level;
    }

    public boolean isOccupied() {
        return this.owner != null;
    }
}

