/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.conductivity.macro.bands;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.conductivity.macro.MacroSystem;
import edu.colorado.phet.conductivity.macro.bands.Band;
import edu.colorado.phet.conductivity.macro.bands.BandParticle;
import edu.colorado.phet.conductivity.macro.bands.BandParticleObserver;
import edu.colorado.phet.conductivity.macro.bands.EnergyCell;
import edu.colorado.phet.conductivity.macro.bands.EnergyLevel;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Random;

public class DefaultBandSet
implements ModelElement {
    protected Band upper;
    protected Band lowband;
    ArrayList bandParticles = new ArrayList();
    ArrayList bandParticleObservers = new ArrayList();
    protected double inset;
    protected Random random = new Random(0L);
    MacroSystem system;
    private double y = 0.1;
    private double boundsHeight = 0.8;
    double lowBandY1 = 0.2;
    double lowBandY2 = 0.4;
    int lowNumLevels = 6;
    int highBandNumLevels = 6;

    public DefaultBandSet(MacroSystem macroSystem, double d) {
        this.system = macroSystem;
        if (macroSystem == null) {
            throw new RuntimeException("Null system.");
        }
        this.inset = d * 2.0;
        this.lowband = new Band(this);
        this.upper = new Band(this);
    }

    public void removeParticles() {
        while (this.bandParticles.size() > 0) {
            this.removeParticle((BandParticle)this.bandParticles.get(0));
        }
    }

    public void initParticles() {
        this.removeParticles();
    }

    public void fillLevel(EnergyLevel energyLevel) {
        BandParticle[] bandParticleArray = energyLevel.fillLevel();
        for (int i = 0; i < bandParticleArray.length; ++i) {
            BandParticle bandParticle = bandParticleArray[i];
            this.addParticle(bandParticle);
        }
    }

    private void addParticle(BandParticle bandParticle) {
        this.bandParticles.add(bandParticle);
        this.fireParticleAdded(bandParticle);
    }

    private void fireParticleAdded(BandParticle bandParticle) {
        for (int i = 0; i < this.bandParticleObservers.size(); ++i) {
            BandParticleObserver bandParticleObserver = (BandParticleObserver)this.bandParticleObservers.get(i);
            bandParticleObserver.particleAdded(bandParticle);
        }
    }

    public Band getUpperBand() {
        return this.upper;
    }

    public Band getLowerBand() {
        return this.lowband;
    }

    public double getX() {
        return 0.1;
    }

    public double getWidth() {
        return 0.14;
    }

    public Rectangle2D.Double getBounds() {
        double d = this.getX();
        double d2 = this.getWidth();
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, this.y, d2, this.boundsHeight);
        double d3 = 0.02;
        double_ = new Rectangle2D.Double(double_.x - d3, double_.y - d3, double_.width + d3 * 2.0, double_.height + d3 * 2.0);
        return double_;
    }

    public double voltageChanged(double d, double d2) {
        this.upper.voltageChanged(d, d2);
        this.lowband.voltageChanged(d, d2);
        return this.desiredSpeedToActualSpeed(d2);
    }

    public double desiredSpeedToActualSpeed(double d) {
        return d;
    }

    public void stepInTime(double d) {
        for (int i = 0; i < this.bandParticles.size(); ++i) {
            BandParticle bandParticle = (BandParticle)this.bandParticles.get(i);
            bandParticle.stepInTime(d);
        }
        this.upper.propagate();
        this.lowband.propagate();
    }

    public void removeParticle(BandParticle bandParticle) {
        bandParticle.detach();
        this.bandParticles.remove(bandParticle);
        this.fireParticleRemoved(bandParticle);
    }

    public void addBandParticleObserver(BandParticleObserver bandParticleObserver) {
        this.bandParticleObservers.add(bandParticleObserver);
    }

    private void fireParticleRemoved(BandParticle bandParticle) {
        for (int i = 0; i < this.bandParticleObservers.size(); ++i) {
            BandParticleObserver bandParticleObserver = (BandParticleObserver)this.bandParticleObservers.get(i);
            bandParticleObserver.particleRemoved(bandParticle);
        }
    }

    protected boolean moveParticle(EnergyLevel energyLevel, EnergyLevel energyLevel2, boolean bl) {
        if (bl) {
            return this.moveParticle(energyLevel2, energyLevel);
        }
        return this.moveParticle(energyLevel, energyLevel2);
    }

    protected boolean moveParticle(EnergyLevel energyLevel, EnergyLevel energyLevel2) {
        int n;
        int n2;
        if (!energyLevel2.hasAnEmptyCell()) {
            return false;
        }
        boolean bl = false;
        for (n2 = n = this.random.nextInt(energyLevel.numCells()); n2 < energyLevel.numCells(); ++n2) {
            bl = this.tryToMove(energyLevel.cellAt(n2), energyLevel2.cellAt(n2));
            if (!bl) continue;
            return true;
        }
        for (n2 = n; n2 >= 0; --n2) {
            bl = this.tryToMove(energyLevel.cellAt(n2), energyLevel2.cellAt(n2));
            if (!bl) continue;
            return true;
        }
        bl = this.tryToMoveAny(energyLevel, energyLevel2);
        return bl;
    }

    private boolean tryToMoveAny(EnergyLevel energyLevel, EnergyLevel energyLevel2) {
        for (int i = 0; i < energyLevel.numCells(); ++i) {
            for (int j = 0; j < energyLevel2.numCells(); ++j) {
                EnergyCell energyCell;
                EnergyCell energyCell2 = energyLevel.cellAt(i);
                boolean bl = this.tryToMove(energyCell2, energyCell = energyLevel2.cellAt(j));
                if (!bl) continue;
                return true;
            }
        }
        return false;
    }

    private boolean tryToMove(EnergyCell energyCell, EnergyCell energyCell2) {
        BandParticle bandParticle = energyCell.getOwner();
        if (bandParticle != null && !energyCell2.isOccupied()) {
            bandParticle.moveTo(energyCell2, 0.006);
            return true;
        }
        return false;
    }

    public EnergyLevel getLowerLevel(EnergyLevel energyLevel) {
        if (this.upper.indexOf(energyLevel) >= 1) {
            return this.upper.energyLevelAt(this.upper.indexOf(energyLevel) - 1);
        }
        if (this.upper.indexOf(energyLevel) == 0) {
            return this.lowband.energyLevelAt(this.lowband.numEnergyLevels() - 1);
        }
        if (this.lowband.indexOf(energyLevel) >= 1) {
            return this.lowband.energyLevelAt(this.lowband.indexOf(energyLevel) - 1);
        }
        return null;
    }

    public void photonGotAbsorbed() {
        this.system.photonGotAbsorbed();
    }
}

