/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.conductivity.macro.bands;

import edu.colorado.phet.conductivity.macro.MacroSystem;
import edu.colorado.phet.conductivity.macro.bands.Band;
import edu.colorado.phet.conductivity.macro.bands.DefaultBandSet;
import edu.colorado.phet.conductivity.macro.bands.EnergyLevel;
import java.util.ArrayList;

public class ConductorBandSet
extends DefaultBandSet {
    public ConductorBandSet(MacroSystem macroSystem, double d) {
        super(macroSystem, d);
        double d2 = d;
        double d3 = d2 * 1.2;
        double d4 = 0.14 + this.inset * 2.0;
        int n = (int)(d4 / d3);
        double d5 = d2 * 0.51;
        this.lowband.addLevels(this.lowBandY1, this.lowBandY2, this.lowNumLevels, 0.1 - this.inset, d4, n, d5, 0.03333333333333333);
        this.upper.addLevels(0.45, 0.65, this.highBandNumLevels, 0.1 - this.inset, d4, n, d5, 0.03333333333333333);
    }

    public void initParticles() {
        super.initParticles();
        for (int i = 0; i <= this.getFermiLevel(); ++i) {
            super.fillLevel(this.getLowerBand().energyLevelAt(i));
        }
    }

    public int getFermiLevel() {
        int n = super.getLowerBand().numEnergyLevels() / 2;
        return n;
    }

    public double voltageChanged(double d, double d2) {
        int n = this.getFermiLevel();
        Band band = this.getLowerBand();
        EnergyLevel energyLevel = band.energyLevelAt(n + 1);
        EnergyLevel energyLevel2 = band.energyLevelAt(n + 2);
        energyLevel.setCanConduct(true);
        energyLevel2.setCanConduct(true);
        if (d == 0.0) {
            this.setConductionCount(0, 0);
        } else if (d > 0.0 && d <= 0.5) {
            this.setConductionCount(1, 0);
        } else if (d > 0.5 & d <= 1.0) {
            this.setConductionCount(1, 1);
        } else if (d > 1.0 && d <= 1.5) {
            this.setConductionCount(2, 1);
        } else if (d > 1.5 && d <= 2.0) {
            this.setConductionCount(2, 2);
        }
        return super.voltageChanged(d, d2);
    }

    private void setConductionCount(int n, int n2) {
        int n3 = this.getFermiLevel();
        Band band = this.getLowerBand();
        ArrayList<EnergyLevel> arrayList = new ArrayList<EnergyLevel>();
        arrayList.add(band.energyLevelAt(n3));
        EnergyLevel energyLevel = band.energyLevelAt(n3 + 1);
        EnergyLevel energyLevel2 = band.energyLevelAt(n3 + 2);
        this.moveParticles(energyLevel, n);
        this.moveParticles(energyLevel2, n2);
    }

    EnergyLevel getDonorLevel() {
        int n;
        for (int i = n = this.getFermiLevel(); i >= 0; --i) {
            if (this.lowband.energyLevelAt(i).numParticles() <= 0) continue;
            return this.lowband.energyLevelAt(i);
        }
        throw new RuntimeException("No Donor level.");
    }

    EnergyLevel getAcceptor() {
        int n;
        for (int i = n = this.getFermiLevel(); i >= 0; --i) {
            if (this.lowband.energyLevelAt(i).numParticles() >= 2) continue;
            return this.lowband.energyLevelAt(i);
        }
        throw new RuntimeException("No Donor level.");
    }

    protected void moveParticles(EnergyLevel energyLevel, int n) {
        EnergyLevel energyLevel2;
        int n2 = 0;
        while (energyLevel.numParticles() > n) {
            energyLevel2 = this.getAcceptor();
            this.moveParticle(energyLevel, energyLevel2);
            if (++n2 <= 100) continue;
            throw new RuntimeException("Loop broke.");
        }
        while (energyLevel.numParticles() < n) {
            energyLevel2 = this.getDonorLevel();
            this.moveParticle(energyLevel2, energyLevel);
            if (++n2 <= 100) continue;
            throw new RuntimeException("Loop broke.");
        }
    }
}

