/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.conductivity.macro.bands;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.util.SimpleObservable;
import edu.colorado.phet.conductivity.macro.bands.BandParticleState;
import edu.colorado.phet.conductivity.macro.bands.EnergyCell;
import edu.colorado.phet.conductivity.macro.bands.EnergyLevel;
import edu.colorado.phet.conductivity.macro.bands.states.MoveTo;
import edu.colorado.phet.conductivity.macro.bands.states.Speed;
import edu.colorado.phet.conductivity.macro.bands.states.Waiting;

public class BandParticle
extends SimpleObservable
implements ModelElement {
    double x;
    double y;
    private EnergyCell cell;
    private BandParticleState state;

    public BandParticle(double d, double d2, EnergyCell energyCell) {
        this.x = d;
        this.y = d2;
        this.cell = energyCell;
        if (energyCell.hasOwner() && energyCell.getOwner() != this) {
            throw new RuntimeException("Wrong owner.");
        }
        energyCell.setOwner(this);
        this.state = new Waiting();
    }

    public Vector2D getPosition() {
        return new Vector2D(this.x, this.y);
    }

    public double getX() {
        return this.x;
    }

    public EnergyCell getEnergyCell() {
        return this.cell;
    }

    public EnergyLevel getEnergyLevel() {
        return this.cell.getEnergyLevel();
    }

    public MoveTo moveTo(EnergyCell energyCell, final double d) {
        return this.moveTo(energyCell, new Speed(){

            public double getSpeed() {
                return d;
            }
        });
    }

    public MoveTo moveTo(EnergyCell energyCell, Speed speed) {
        this.cell.detach(this);
        energyCell.setOwner(this);
        this.state = new MoveTo(energyCell, speed);
        this.cell = energyCell;
        return (MoveTo)this.state;
    }

    public void stepInTime(double d) {
        this.state = this.state.stepInTime(this, d);
    }

    public void setPosition(Vector2D vector2D) {
        this.x = vector2D.getX();
        this.y = vector2D.getY();
        this.notifyObservers();
    }

    public double getDistanceFromOwnedSite() {
        Vector2D vector2D = this.cell.getPosition();
        return this.getPosition().getSubtractedInstance(vector2D).getMagnitude();
    }

    public void detach() {
        if (this.cell != null) {
            this.cell.detach(this);
        }
        this.cell = null;
    }

    public void setX(double d) {
        this.setPosition(new Vector2D(d, this.getPosition().getY()));
    }

    public void pairPropagate(BandParticle bandParticle, Speed speed) {
        if (this.getDistanceFromOwnedSite() < 1.0E-4 && bandParticle.getDistanceFromOwnedSite() < 1.0E-4) {
            EnergyCell energyCell = bandParticle.getEnergyCell();
            EnergyCell energyCell2 = this.getEnergyCell();
            this.cell.detach(this);
            bandParticle.cell.detach(bandParticle);
            energyCell.setOwner(this);
            energyCell2.setOwner(bandParticle);
            this.state = new MoveTo(energyCell, speed);
            bandParticle.state = new MoveTo(energyCell2, speed);
            this.cell = energyCell;
            bandParticle.cell = energyCell2;
        }
    }
}

