/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.conductivity.macro.bands;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.TransformListener;
import edu.colorado.phet.conductivity.macro.bands.Band;
import edu.colorado.phet.conductivity.macro.bands.EnergyLevel;
import edu.colorado.phet.conductivity.oldphetgraphics.Graphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class BandGraphic
implements Graphic {
    Band band;
    private ModelViewTransform2D transform;
    Stroke stroke = new BasicStroke(2.0f);

    public BandGraphic(Band band, ModelViewTransform2D modelViewTransform2D) {
        this.band = band;
        this.transform = modelViewTransform2D;
        modelViewTransform2D.addTransformListener(new TransformListener(){

            public void transformChanged(ModelViewTransform2D modelViewTransform2D) {
                BandGraphic.this.update();
            }
        });
    }

    private void update() {
    }

    public void paint(Graphics2D graphics2D) {
        Stroke stroke = graphics2D.getStroke();
        AffineTransform affineTransform = this.transform.getAffineTransform();
        Rectangle2D.Double double_ = this.band.getBounds();
        graphics2D.setColor(Color.yellow);
        graphics2D.fill(affineTransform.createTransformedShape(double_));
        graphics2D.setStroke(this.stroke);
        graphics2D.setColor(Color.black);
        for (int i = 0; i < this.band.numEnergyLevels(); ++i) {
            EnergyLevel energyLevel = this.band.energyLevelAt(i);
            Line2D.Double double_2 = energyLevel.getLine();
            Shape shape = affineTransform.createTransformedShape(double_2);
            graphics2D.draw(shape);
        }
        Line2D.Double double_3 = this.band.getTopLine();
        graphics2D.draw(affineTransform.createTransformedShape(double_3));
        graphics2D.setStroke(stroke);
    }
}

