/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.conductivity.macro.bands;

import edu.colorado.phet.conductivity.ConductivityResources;
import edu.colorado.phet.conductivity.macro.bands.DefaultBandSet;
import edu.colorado.phet.conductivity.macro.bands.EnergyLevel;
import edu.colorado.phet.conductivity.macro.bands.states.Speed;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class Band {
    ArrayList levels = new ArrayList();
    private double voltage;
    private double speed;
    DefaultBandSet bandSet;
    private double de;

    public Band(DefaultBandSet defaultBandSet) {
        this.bandSet = defaultBandSet;
    }

    public double getSpeed() {
        return this.speed;
    }

    public String toString() {
        if (this.bandSet.getUpperBand() == this) {
            return ConductivityResources.getString("Band.UpperLabel");
        }
        if (this.bandSet.getLowerBand() == this) {
            return ConductivityResources.getString("Band.LowerLabel");
        }
        return super.toString();
    }

    public void addLevels(double d, double d2, int n, double d3, double d4, int n2, double d5, double d6) {
        this.de = d6;
        double d7 = d;
        for (int i = 0; i < n; ++i) {
            EnergyLevel energyLevel = new EnergyLevel(this, d3, d7, d4, 2, d5);
            this.addLevel(energyLevel);
            d7 += d6;
        }
    }

    private void addLevel(EnergyLevel energyLevel) {
        this.levels.add(energyLevel);
    }

    public int numEnergyLevels() {
        return this.levels.size();
    }

    public EnergyLevel energyLevelAt(int n) {
        return (EnergyLevel)this.levels.get(n);
    }

    public int indexOf(EnergyLevel energyLevel) {
        return this.levels.indexOf(energyLevel);
    }

    public double getVoltage() {
        return this.voltage;
    }

    public void voltageChanged(double d, double d2) {
        this.voltage = d;
        this.speed = d2;
    }

    public DefaultBandSet getBandSet() {
        return this.bandSet;
    }

    public int numParticles() {
        int n = 0;
        for (int i = 0; i < this.levels.size(); ++i) {
            EnergyLevel energyLevel = (EnergyLevel)this.levels.get(i);
            n += energyLevel.numParticles();
        }
        return n;
    }

    public Rectangle2D.Double getBounds() {
        EnergyLevel energyLevel = this.energyLevelAt(0);
        EnergyLevel energyLevel2 = this.energyLevelAt(this.numEnergyLevels() - 1);
        double d = energyLevel2.getY() - energyLevel.getY() + this.de;
        Rectangle2D.Double double_ = new Rectangle2D.Double(energyLevel.x, energyLevel.y, energyLevel.getWidth(), d);
        return double_;
    }

    public Line2D.Double getTopLine() {
        Line2D.Double double_ = this.energyLevelAt(this.numEnergyLevels() - 1).getLine();
        return new Line2D.Double(double_.getX1(), double_.getY1() + this.de, double_.getX2(), double_.getY2() + this.de);
    }

    public void propagate() {
        for (int i = 0; i < this.numEnergyLevels(); ++i) {
            EnergyLevel energyLevel = this.energyLevelAt(i);
            if (!energyLevel.canConduct() || !energyLevel.isFull()) continue;
            energyLevel.propagateBoth(new Speed(){

                public double getSpeed() {
                    return Band.this.speed;
                }
            });
        }
    }
}

