/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.conductivity.macro;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.conductivity.macro.bands.ConductorBandSet;
import edu.colorado.phet.conductivity.macro.bands.DefaultBandSet;
import edu.colorado.phet.conductivity.macro.bands.InsulatorBandSet;
import edu.colorado.phet.conductivity.macro.bands.PhotoconductorBandSet;
import edu.colorado.phet.conductivity.macro.battery.Battery;
import edu.colorado.phet.conductivity.macro.battery.BatteryListener;
import edu.colorado.phet.conductivity.macro.circuit.MacroCircuit;
import edu.colorado.phet.conductivity.macro.particles.WireParticle;
import java.util.ArrayList;

public class MacroSystem
implements ModelElement {
    private MacroCircuit circuit;
    public ArrayList particles = new ArrayList();
    private double minVolts;
    private double maxVolts;
    DefaultBandSet bandSet;
    private double recommendedSpeed;
    private ConductorBandSet conductor;
    private InsulatorBandSet insulator;
    private PhotoconductorBandSet photoconductor;

    public DefaultBandSet getBandSet() {
        return this.bandSet;
    }

    public MacroSystem(double d, double d2, double d3) {
        this.minVolts = d;
        this.maxVolts = d2;
        this.circuit = new MacroCircuit();
        Battery battery = this.circuit.getBattery();
        battery.addBatteryListener(new BatteryListener(){

            public void voltageChanged(Battery battery) {
                MacroSystem.this.doVoltageChanged();
            }
        });
        this.conductor = new ConductorBandSet(this, d3);
        this.insulator = new InsulatorBandSet(this, d3);
        this.photoconductor = new PhotoconductorBandSet(this, d3);
        this.setBandSet(this.conductor);
    }

    public MacroCircuit getCircuit() {
        return this.circuit;
    }

    public void doVoltageChanged() {
        double d = this.circuit.getBattery().getVoltage();
        double d2 = -0.006;
        double d3 = 0.0;
        double d4 = this.maxVolts - this.minVolts;
        double d5 = d2 - d3;
        double d6 = d5 / d4;
        double d7 = d3;
        this.recommendedSpeed = d * d6 + d7;
        double d8 = this.bandSet.voltageChanged(d, this.recommendedSpeed);
        for (int i = 0; i < this.particles.size(); ++i) {
            WireParticle wireParticle = (WireParticle)this.particles.get(i);
            wireParticle.setSpeed(d8);
        }
    }

    public void stepInTime(double d) {
        this.bandSet.stepInTime(d);
    }

    public void setBandSet(DefaultBandSet defaultBandSet) {
        this.bandSet = defaultBandSet;
    }

    public void photonHit() {
        this.photoconductor.photonHit();
    }

    public ConductorBandSet getConductor() {
        return this.conductor;
    }

    public InsulatorBandSet getInsulator() {
        return this.insulator;
    }

    public PhotoconductorBandSet getPhotoconductor() {
        return this.photoconductor;
    }

    public void photonGotAbsorbed() {
        double d = this.circuit.getBattery().getVoltage();
        double d2 = -0.006;
        double d3 = 0.0;
        double d4 = this.maxVolts - this.minVolts;
        double d5 = d2 - d3;
        double d6 = d5 / d4;
        double d7 = d3;
        this.recommendedSpeed = d * d6 + d7;
        double d8 = this.bandSet.desiredSpeedToActualSpeed(this.recommendedSpeed);
        for (int i = 0; i < this.particles.size(); ++i) {
            WireParticle wireParticle = (WireParticle)this.particles.get(i);
            wireParticle.setSpeed(d8);
        }
    }
}

