/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.conductivity.macro;

import edu.colorado.phet.conductivity.ConductivityApplication;
import edu.colorado.phet.conductivity.ConductivityResources;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MacroControlPanel
extends JPanel {
    private JCheckBox lightOn;
    private JButton onePhoton;

    public MacroControlPanel(final ConductivityApplication conductivityApplication) {
        JRadioButton jRadioButton = new JRadioButton(ConductivityResources.getString("MacroControlPanel.MetalRadioButton"));
        JRadioButton jRadioButton2 = new JRadioButton(ConductivityResources.getString("MacroControlPanel.PlasticRadioButton"));
        JRadioButton jRadioButton3 = new JRadioButton(ConductivityResources.getString("MacroControlPanel.PhotoconductorRadioButton"));
        jRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                conductivityApplication.setConductor();
            }
        });
        jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                conductivityApplication.setInsulator();
            }
        });
        jRadioButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                conductivityApplication.setPhotoconductor();
            }
        });
        this.setLayout(new BoxLayout(this, 1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        jRadioButton.setSelected(true);
        jPanel.add(jRadioButton);
        jPanel.add(jRadioButton2);
        jPanel.add(jRadioButton3);
        Border border = BorderFactory.createRaisedBevelBorder();
        border = BorderFactory.createTitledBorder(border, ConductivityResources.getString("MacroControlPanel.MaterialsBorder"));
        jPanel.setBorder(border);
        this.add(jPanel);
        this.lightOn = new JCheckBox(ConductivityResources.getString("MacroControlPanel.ShineLightCheckBox"));
        this.lightOn.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                conductivityApplication.setFlashlightOn(MacroControlPanel.this.lightOn.isSelected());
            }
        });
        this.add(this.lightOn);
        this.onePhoton = new JButton(ConductivityResources.getString("MacroControlPanel.FirePhotonButton"));
        this.onePhoton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                conductivityApplication.firePhoton();
            }
        });
    }

    public void disableFlashlight() {
        this.lightOn.setEnabled(false);
        this.onePhoton.setEnabled(false);
        this.repaint();
    }

    public void enableFlashlight() {
        this.lightOn.setEnabled(true);
        this.onePhoton.setEnabled(true);
        this.repaint();
    }
}

