/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.conductivity.macro;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.conductivity.ConductivityResources;
import edu.colorado.phet.conductivity.common.ArrowShape;
import edu.colorado.phet.conductivity.common.TransformGraphic;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class EnergyTextGraphic
extends TransformGraphic {
    private Font font;
    private String text;
    private Vector2D loc;
    private Shape trfShape;
    private Shape arrowShape;
    private Graphics2D graphics2D;
    private Font smallFont;
    private Shape highShape;
    private Shape lowShape;

    public EnergyTextGraphic(ModelViewTransform2D modelViewTransform2D, Vector2D vector2D) {
        super(modelViewTransform2D);
        this.loc = vector2D;
        this.text = ConductivityResources.getString("EnergyTextGraphic.EnergyText");
        this.font = new PhetFont(0, 36);
        this.smallFont = new PhetFont(0, 18);
    }

    public void paint(Graphics2D graphics2D) {
        this.graphics2D = graphics2D;
        if (this.trfShape == null) {
            this.recompute();
        }
        graphics2D.setColor(Color.blue);
        graphics2D.fill(this.trfShape);
        graphics2D.fill(this.arrowShape);
        graphics2D.setColor(Color.black);
        graphics2D.fill(this.lowShape);
        graphics2D.fill(this.highShape);
    }

    private Vector2D getTopCenter(Rectangle2D rectangle2D) {
        return new Vector2D(rectangle2D.getX() + rectangle2D.getWidth() / 2.0, rectangle2D.getY());
    }

    public void recompute() {
        GlyphVector glyphVector = this.font.createGlyphVector(this.graphics2D.getFontRenderContext(), this.text);
        Shape shape = glyphVector.getOutline();
        Point point = this.getTransform().modelToView(this.loc);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(point.x - 15, point.y);
        affineTransform.rotate(-1.5707963267948966);
        this.trfShape = affineTransform.createTransformedShape(shape);
        ImmutableVector2D immutableVector2D = this.getTopCenter(this.trfShape.getBounds2D());
        immutableVector2D = immutableVector2D.getSubtractedInstance(0.0, 40.0);
        ImmutableVector2D immutableVector2D2 = immutableVector2D.getAddedInstance(0.0, -200.0);
        this.arrowShape = new ArrowShape(immutableVector2D, immutableVector2D2, 50.0, 50.0, 20.0).getArrowPath();
        this.highShape = this.smallFont.createGlyphVector(this.graphics2D.getFontRenderContext(), ConductivityResources.getString("EnergyTextGraphic.HighText")).getOutline((float)immutableVector2D2.getX() - 20.0f, (float)immutableVector2D2.getY() - 20.0f);
        this.lowShape = this.smallFont.createGlyphVector(this.graphics2D.getFontRenderContext(), ConductivityResources.getString("EnergyTextGraphic.LowText")).getOutline((float)immutableVector2D.getX() - 20.0f, (float)immutableVector2D.getY() + 20.0f);
    }

    public void update() {
        this.trfShape = null;
    }
}

