/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.conductivity.macro;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.conductivity.common.ClipGraphic;
import edu.colorado.phet.conductivity.common.TransformGraphic;
import edu.colorado.phet.conductivity.macro.bands.BandGraphic;
import edu.colorado.phet.conductivity.macro.bands.BandParticle;
import edu.colorado.phet.conductivity.macro.bands.BandParticleGraphic;
import edu.colorado.phet.conductivity.macro.bands.BandParticleObserver;
import edu.colorado.phet.conductivity.macro.bands.DefaultBandSet;
import edu.colorado.phet.conductivity.macro.circuit.MacroCircuitGraphic;
import edu.colorado.phet.conductivity.oldphetgraphics.CompositeInteractiveGraphic;
import edu.colorado.phet.conductivity.oldphetgraphics.Graphic;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.io.IOException;
import java.util.Hashtable;

public class BandSetGraphic
extends TransformGraphic
implements BandParticleObserver {
    CompositeInteractiveGraphic graphic = new CompositeInteractiveGraphic();
    ClipGraphic clipGraphic;
    Hashtable bandParticleGraphicTable = new Hashtable();

    public BandSetGraphic(ModelViewTransform2D modelViewTransform2D, Shape shape, DefaultBandSet defaultBandSet) {
        super(modelViewTransform2D);
        this.clipGraphic = new ClipGraphic(this.getTransform(), this.graphic, shape);
        BandGraphic bandGraphic = new BandGraphic(defaultBandSet.getUpperBand(), modelViewTransform2D);
        this.graphic.addGraphic(bandGraphic, 1.0);
        BandGraphic bandGraphic2 = new BandGraphic(defaultBandSet.getLowerBand(), modelViewTransform2D);
        this.graphic.addGraphic(bandGraphic2, 1.0);
    }

    public void particleRemoved(BandParticle bandParticle) {
        Graphic graphic = (Graphic)this.bandParticleGraphicTable.get(bandParticle);
        this.graphic.remove(graphic);
        this.bandParticleGraphicTable.remove(bandParticle);
    }

    public void particleAdded(BandParticle bandParticle) {
        try {
            BandParticleGraphic bandParticleGraphic = new BandParticleGraphic(bandParticle, this.getTransform(), MacroCircuitGraphic.getParticleImage());
            this.bandParticleGraphicTable.put(bandParticle, bandParticleGraphic);
            this.graphic.addGraphic(bandParticleGraphic, 1.0);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void update() {
    }

    public void paint(Graphics2D graphics2D) {
        this.clipGraphic.paint(graphics2D);
    }
}

