/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.conductivity.common;

import edu.colorado.phet.conductivity.oldphetgraphics.Graphic;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class SimpleBufferedImageGraphic
implements Graphic {
    BufferedImage image;
    AffineTransform transform;

    public SimpleBufferedImageGraphic(BufferedImage bufferedImage) {
        this.image = bufferedImage;
    }

    public void paint(Graphics2D graphics2D) {
        if (this.image != null && this.transform != null) {
            graphics2D.drawRenderedImage(this.image, this.transform);
        }
    }

    public void setTransform(AffineTransform affineTransform) {
        this.transform = affineTransform;
    }

    public void setPosition(Point point) {
        this.setTransform(this.getCenterTransform(point));
    }

    public AffineTransform getCenterTransform(Point point) {
        double d = this.image.getWidth();
        double d2 = this.image.getHeight();
        AffineTransform affineTransform = AffineTransform.getTranslateInstance((double)point.x - d / 2.0, (double)point.y - d2 / 2.0);
        return affineTransform;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }
}

