/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.conductivity.common;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.util.SimpleObservable;

public class Particle
extends SimpleObservable
implements ModelElement {
    ImmutableVector2D position;
    ImmutableVector2D velocity;
    Vector2D acceleration;

    public Particle(double d, double d2) {
        this.position = new Vector2D(d, d2);
        this.velocity = new Vector2D();
        this.acceleration = new Vector2D();
    }

    public ImmutableVector2D getPosition() {
        return this.position;
    }

    public ImmutableVector2D getVelocity() {
        return this.velocity;
    }

    public void stepInTime(double d) {
        ImmutableVector2D immutableVector2D = this.acceleration.getScaledInstance(d);
        this.velocity = this.velocity.getAddedInstance(immutableVector2D);
        ImmutableVector2D immutableVector2D2 = this.velocity.getScaledInstance(d);
        this.position = this.position.getAddedInstance(immutableVector2D2);
        this.notifyObservers();
    }

    public void setAcceleration(double d, double d2) {
        this.acceleration = new Vector2D(d, d2);
    }

    public void setVelocity(double d, double d2) {
        this.velocity = new Vector2D(d, d2);
    }

    public void setPosition(double d, double d2) {
        this.position = new Vector2D(d, d2);
    }
}

