/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.conductivity.common;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.conductivity.common.DoubleGeneralPath;
import java.awt.geom.GeneralPath;

public class ArrowShape {
    GeneralPath arrowPath;
    ImmutableVector2D tipLocation;
    private ImmutableVector2D direction;
    private ImmutableVector2D norm;

    public ArrowShape(ImmutableVector2D immutableVector2D, ImmutableVector2D immutableVector2D2, double d, double d2, double d3) {
        this.direction = immutableVector2D2.getSubtractedInstance(immutableVector2D).getNormalizedInstance();
        double d4 = immutableVector2D2.getSubtractedInstance(immutableVector2D).getMagnitude();
        if (d4 < d) {
            throw new RuntimeException("Head too big.");
        }
        this.norm = this.direction.getNormalVector();
        this.tipLocation = immutableVector2D2;
        ImmutableVector2D immutableVector2D3 = this.getPoint(-1.0 * d, -d2 / 2.0);
        ImmutableVector2D immutableVector2D4 = this.getPoint(-1.0 * d, d2 / 2.0);
        ImmutableVector2D immutableVector2D5 = this.getPoint(-1.0 * d, -d3 / 2.0);
        ImmutableVector2D immutableVector2D6 = this.getPoint(-1.0 * d, d3 / 2.0);
        ImmutableVector2D immutableVector2D7 = this.getPoint(-1.0 * d4, -d3 / 2.0);
        ImmutableVector2D immutableVector2D8 = this.getPoint(-1.0 * d4, d3 / 2.0);
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath(immutableVector2D2.getX(), immutableVector2D2.getY());
        doubleGeneralPath.lineTo(immutableVector2D3);
        doubleGeneralPath.lineTo(immutableVector2D5);
        doubleGeneralPath.lineTo(immutableVector2D7);
        doubleGeneralPath.lineTo(immutableVector2D8);
        doubleGeneralPath.lineTo(immutableVector2D6);
        doubleGeneralPath.lineTo(immutableVector2D4);
        doubleGeneralPath.lineTo(immutableVector2D2.getX(), immutableVector2D2.getY());
        this.arrowPath = doubleGeneralPath.getGeneralPath();
    }

    private ImmutableVector2D getPoint(double d, double d2) {
        ImmutableVector2D immutableVector2D = this.direction.getScaledInstance(d).getAddedInstance(this.norm.getScaledInstance(d2));
        return this.tipLocation.getAddedInstance(immutableVector2D);
    }

    public GeneralPath getArrowPath() {
        return this.arrowPath;
    }
}

