/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.conductivity;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.TransformListener;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.conductivity.Photon;
import edu.colorado.phet.conductivity.oldphetgraphics.Graphic;
import edu.colorado.phet.conductivity.oldphetgraphics.ImageGraphic;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.io.IOException;

public class PhotonArrowGraphic
implements Graphic {
    Photon photon;
    ModelViewTransform2D transform;
    ImageGraphic shapeGraphic;

    public PhotonArrowGraphic(Photon photon, ModelViewTransform2D modelViewTransform2D) {
        this.photon = photon;
        this.transform = modelViewTransform2D;
        try {
            this.shapeGraphic = new ImageGraphic(ImageLoader.loadBufferedImage("conductivity/images/photon-comet-42.png"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        modelViewTransform2D.addTransformListener(new TransformListener(){

            public void transformChanged(ModelViewTransform2D modelViewTransform2D) {
                PhotonArrowGraphic.this.doUpdate();
            }
        });
        photon.addObserver(new SimpleObserver(){

            public void update() {
                PhotonArrowGraphic.this.doUpdate();
            }
        });
        this.doUpdate();
    }

    private void doUpdate() {
        Vector2D vector2D = new Vector2D(this.photon.getPosition());
        ImmutableVector2D immutableVector2D = this.photon.getVelocity();
        Point point = this.transform.modelToViewDifferential(immutableVector2D.getX(), immutableVector2D.getY());
        Vector2D vector2D2 = new Vector2D(point);
        Vector2D vector2D3 = new Vector2D(this.transform.modelToView(vector2D));
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(vector2D3.getX(), vector2D3.getY());
        double d = -0.09817477042468103;
        double d2 = vector2D2.getAngle() - 1.5707963267948966 + d;
        affineTransform.rotate(-d2);
        this.shapeGraphic.setTransform(affineTransform);
    }

    public void paint(Graphics2D graphics2D) {
        this.shapeGraphic.paint(graphics2D);
    }
}

