/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.conductivity;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.util.SimpleObservable;
import edu.colorado.phet.conductivity.common.Particle;

public class Photon
extends SimpleObservable
implements ModelElement {
    Particle particle = new Particle(0.0, 0.0);

    public void setPosition(double d, double d2) {
        this.particle.setPosition(d, d2);
        this.notifyObservers();
    }

    public void setVelocity(ImmutableVector2D immutableVector2D) {
        this.particle.setVelocity(immutableVector2D.getX(), immutableVector2D.getY());
        this.notifyObservers();
    }

    public ImmutableVector2D getPosition() {
        return this.particle.getPosition();
    }

    public void stepInTime(double d) {
        this.particle.setAcceleration(0.0, 0.0);
        this.particle.stepInTime(d);
        this.notifyObservers();
    }

    public void setPosition(Vector2D vector2D) {
        this.setPosition(vector2D.getX(), vector2D.getY());
    }

    public ImmutableVector2D getVelocity() {
        return this.particle.getVelocity();
    }

    public double getSpeed() {
        return this.getVelocity().getMagnitude();
    }
}

