/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.conductivity;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.TransformListener;
import edu.colorado.phet.conductivity.Flashlight;
import edu.colorado.phet.conductivity.common.SimpleBufferedImageGraphic;
import edu.colorado.phet.conductivity.oldphetgraphics.Graphic;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class FlashlightGraphic
implements Graphic {
    private Flashlight light;
    private BufferedImage lightImage;
    private ModelViewTransform2D transform;
    private SimpleBufferedImageGraphic imageGraphic;
    private boolean visible;

    public FlashlightGraphic(Flashlight flashlight, BufferedImage bufferedImage, ModelViewTransform2D modelViewTransform2D) {
        this.light = flashlight;
        this.lightImage = bufferedImage;
        this.transform = modelViewTransform2D;
        this.imageGraphic = new SimpleBufferedImageGraphic(bufferedImage);
        modelViewTransform2D.addTransformListener(new TransformListener(){

            public void transformChanged(ModelViewTransform2D modelViewTransform2D) {
                FlashlightGraphic.this.doUpdate();
            }
        });
        flashlight.addObserver(new SimpleObserver(){

            public void update() {
                FlashlightGraphic.this.doUpdate();
            }
        });
    }

    private void doUpdate() {
        Point point = this.transform.modelToView(this.light.getPosition());
        this.imageGraphic.setPosition(point);
        AffineTransform affineTransform = this.imageGraphic.getTransform();
        double d = this.light.getAngle();
        affineTransform.rotate(d, this.lightImage.getWidth() / 2, this.lightImage.getHeight() / 2);
        this.imageGraphic.setTransform(affineTransform);
    }

    public void paint(Graphics2D graphics2D) {
        if (this.visible) {
            this.imageGraphic.paint(graphics2D);
        }
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }
}

