/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.conductivity;

import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.TransformListener;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.conductivity.Flashlight;
import edu.colorado.phet.conductivity.FlashlightGraphic;
import edu.colorado.phet.conductivity.Photon;
import edu.colorado.phet.conductivity.PhotonArrowGraphic;
import edu.colorado.phet.conductivity.macro.BandSetGraphic;
import edu.colorado.phet.conductivity.macro.EnergyTextGraphic;
import edu.colorado.phet.conductivity.macro.MacroControlPanel;
import edu.colorado.phet.conductivity.macro.MacroSystem;
import edu.colorado.phet.conductivity.macro.bands.DefaultBandSet;
import edu.colorado.phet.conductivity.macro.battery.BatterySpinner;
import edu.colorado.phet.conductivity.macro.circuit.MacroCircuit;
import edu.colorado.phet.conductivity.macro.circuit.MacroCircuitGraphic;
import edu.colorado.phet.conductivity.macro.particles.WireParticle;
import edu.colorado.phet.conductivity.macro.particles.WireParticleGraphic;
import edu.colorado.phet.conductivity.oldphetgraphics.ApparatusPanel;
import edu.colorado.phet.conductivity.oldphetgraphics.Graphic;
import edu.colorado.phet.conductivity.oldphetgraphics.ShapeGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JSpinner;

public class ConductivityApplication {
    double minVolts;
    double maxVolts;
    private MacroSystem model;
    MacroCircuit circuit;
    private MacroCircuitGraphic circuitGraphic;
    private ModelViewTransform2D transform;
    private BatterySpinner batterySpinner;
    private Hashtable bandSetGraphicTable;
    private Flashlight light;
    private boolean lightOn;
    private IClock clock;
    private double timeBetweenFires;
    private ArrayList photons;
    private MacroControlPanel macroControlPanel;
    private FlashlightGraphic flashlightGraphic;
    double timeSinceFire;
    Hashtable photonGraphicTable;
    private ApparatusPanel apparatusPanel;
    private MacroControlPanel controlPanel;
    private BaseModel baseModel;

    public ConductivityApplication(IClock iClock) throws IOException {
        Graphic graphic;
        Object object;
        this.clock = iClock;
        iClock.addClockListener(new ClockAdapter(){

            public void simulationTimeChanged(ClockEvent clockEvent) {
                ConductivityApplication.this.baseModel.update(clockEvent);
            }
        });
        this.minVolts = 0.0;
        this.maxVolts = 2.0;
        this.bandSetGraphicTable = new Hashtable();
        this.photons = new ArrayList();
        this.timeSinceFire = Double.MAX_VALUE;
        this.photonGraphicTable = new Hashtable();
        this.transform = new ModelViewTransform2D(new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0), new Rectangle(0, 0, 600, 600));
        this.setApparatusPanel(new ApparatusPanel());
        this.getApparatusPanel().setBackground(new Color(230, 220, 255));
        this.macroControlPanel = new MacroControlPanel(this);
        this.setControlPanel(this.macroControlPanel);
        this.setBaseModel(new BaseModel());
        this.addViewBoundsListener();
        double d = this.transform.viewToModelDifferentialX(MacroCircuitGraphic.getParticleImage().getWidth());
        this.model = new MacroSystem(this.minVolts, this.maxVolts, d);
        this.circuit = this.model.getCircuit();
        this.circuitGraphic = new MacroCircuitGraphic(this.circuit, this.transform);
        for (int i = 0; i < this.circuitGraphic.numWireGraphics(); ++i) {
            this.getApparatusPanel().addGraphic(this.circuitGraphic.wireGraphicAt(i), 0.0);
        }
        this.getApparatusPanel().addGraphic(this.circuitGraphic.getBatteryGraphic(), 2.0);
        this.getApparatusPanel().addGraphic(this.circuitGraphic.getResistorGraphic(), 2.0);
        this.getBaseModel().addModelElement(this.model);
        double d2 = 0.05;
        double d3 = this.circuit.getLength();
        int n = (int)(d3 / d2 + 1.0);
        double d4 = 0.0;
        for (int i = 0; i < n; ++i) {
            object = new WireParticle(d4, this.circuit);
            this.getBaseModel().addModelElement((ModelElement)object);
            this.model.particles.add(object);
            graphic = new WireParticleGraphic((WireParticle)object, this.transform, MacroCircuitGraphic.getParticleImage());
            this.getApparatusPanel().addGraphic(graphic, 3.0);
            d4 += d2;
        }
        Rectangle2D.Double double_ = this.model.getBandSet().getBounds();
        object = new ShapeGraphic(double_, Color.white);
        graphic = new ShapeGraphic(double_, Color.blue, new BasicStroke(2.0f, 1, 1));
        final Rectangle2D.Double double_2 = double_;
        this.transform.addTransformListener(new TransformListener((ShapeGraphic)object, (ShapeGraphic)graphic){
            final /* synthetic */ ShapeGraphic val$backgroundWhite;
            final /* synthetic */ ShapeGraphic val$backgroundBorder;
            {
                this.val$backgroundWhite = shapeGraphic;
                this.val$backgroundBorder = shapeGraphic2;
            }

            public void transformChanged(ModelViewTransform2D modelViewTransform2D) {
                Shape shape = ConductivityApplication.this.transform.getAffineTransform().createTransformedShape(double_2);
                this.val$backgroundWhite.setShape(shape);
                this.val$backgroundBorder.setShape(shape);
            }
        });
        this.getApparatusPanel().addGraphic((Graphic)object, -1.0);
        this.getApparatusPanel().addGraphic(graphic, 4.0);
        this.batterySpinner = new BatterySpinner(this.circuit.getBattery(), this);
        this.getApparatusPanel().setLayout(null);
        this.transform.addTransformListener(new TransformListener(){

            public void transformChanged(ModelViewTransform2D modelViewTransform2D) {
                ConductivityApplication.this.relayoutBatterySpinner();
            }
        });
        this.getApparatusPanel().add(this.batterySpinner.getSpinner());
        this.addLight();
        this.addCableGraphic();
        this.setConductor();
        Rectangle2D.Double double_3 = this.model.getBandSet().getBounds();
        Vector2D vector2D = new Vector2D(double_3.x, double_3.y);
        EnergyTextGraphic energyTextGraphic = new EnergyTextGraphic(this.transform, vector2D);
        this.getApparatusPanel().addGraphic(energyTextGraphic, 1000.0);
    }

    private void setBaseModel(BaseModel baseModel) {
        this.baseModel = baseModel;
    }

    private void setControlPanel(MacroControlPanel macroControlPanel) {
        this.controlPanel = macroControlPanel;
    }

    private void setApparatusPanel(ApparatusPanel apparatusPanel) {
        this.apparatusPanel = apparatusPanel;
    }

    private void addLight() throws IOException {
        this.timeBetweenFires = 3.0;
        this.light = new Flashlight(0.8, 0.1, 0.0);
        ImageLoader imageLoader = new ImageLoader();
        BufferedImage bufferedImage = imageLoader.loadImage("conductivity/images/light.gif");
        this.flashlightGraphic = new FlashlightGraphic(this.light, bufferedImage, this.transform);
        this.getApparatusPanel().addGraphic(this.flashlightGraphic, 100.0);
        ImmutableVector2D immutableVector2D = this.getResistorCenter();
        this.pointAt(immutableVector2D);
        ModelElement modelElement = new ModelElement(){

            public void stepInTime(double d) {
                if (ConductivityApplication.this.timeSinceFire > ConductivityApplication.this.timeBetweenFires && ConductivityApplication.this.lightOn) {
                    ConductivityApplication.this.firePhoton();
                    ConductivityApplication.this.timeSinceFire = 0.0;
                } else {
                    ConductivityApplication.this.timeSinceFire += d;
                }
            }
        };
        this.getBaseModel().addModelElement(modelElement);
        this.getBaseModel().addModelElement(new ModelElement(){

            public void stepInTime(double d) {
                ImmutableVector2D immutableVector2D = ConductivityApplication.this.getResistorCenter();
                for (int i = 0; i < ConductivityApplication.this.photons.size(); ++i) {
                    Photon photon = (Photon)ConductivityApplication.this.photons.get(i);
                    photon.stepInTime(d);
                    double d2 = photon.getPosition().getSubtractedInstance(immutableVector2D).getMagnitude();
                    int n = 5;
                    if (!(d2 <= photon.getSpeed() * d * (double)n)) continue;
                    ConductivityApplication.this.photons.remove(i);
                    Graphic graphic = (Graphic)ConductivityApplication.this.photonGraphicTable.get(photon);
                    ConductivityApplication.this.getApparatusPanel().removeGraphic(graphic);
                    ConductivityApplication.this.model.photonHit();
                }
            }
        });
    }

    private ImmutableVector2D getResistorCenter() {
        Vector2D vector2D = this.circuit.getResistor().getStartPosition();
        Vector2D vector2D2 = this.circuit.getResistor().getEndPosition();
        ImmutableVector2D immutableVector2D = vector2D2.getSubtractedInstance(vector2D).getScaledInstance(0.5);
        ImmutableVector2D immutableVector2D2 = vector2D.getAddedInstance(immutableVector2D);
        return immutableVector2D2;
    }

    public void pointAt(ImmutableVector2D immutableVector2D) {
        Vector2D vector2D = this.light.getPosition();
        ImmutableVector2D immutableVector2D2 = immutableVector2D.getSubtractedInstance(vector2D).getNormalizedInstance();
        double d = immutableVector2D2.getAngle();
        double d2 = Math.toRadians(126.0);
        double d3 = -d + d2;
        this.light.setAngle(d3);
    }

    private void addCableGraphic() {
        Rectangle2D.Double double_ = this.model.getBandSet().getBounds();
        final GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)double_.getX() + (float)double_.getWidth() / 2.0f, (float)double_.getY());
        MacroCircuit macroCircuit = this.model.getCircuit();
        ImmutableVector2D immutableVector2D = macroCircuit.getResistor().getLocation(macroCircuit.getResistor().getLength() / 2.0);
        Vector2D vector2D = new Vector2D(double_.getX() + 0.3, double_.getY() - 0.2);
        ImmutableVector2D immutableVector2D2 = immutableVector2D.getSubtractedInstance(0.0, 0.1);
        generalPath.curveTo((float)vector2D.getX(), (float)vector2D.getY(), (float)immutableVector2D2.getX(), (float)immutableVector2D2.getY(), (float)immutableVector2D.getX(), (float)immutableVector2D.getY());
        final ShapeGraphic shapeGraphic = new ShapeGraphic(generalPath, Color.black, new BasicStroke(2.0f));
        this.transform.addTransformListener(new TransformListener(){

            public void transformChanged(ModelViewTransform2D modelViewTransform2D) {
                Shape shape = ConductivityApplication.this.transform.getAffineTransform().createTransformedShape(generalPath);
                shapeGraphic.setShape(shape);
            }
        });
        this.getApparatusPanel().addGraphic(shapeGraphic, 3.0);
    }

    private void relayoutBatterySpinner() {
        Point point = this.transform.modelToView(this.circuit.getBattery().getEndPosition());
        JSpinner jSpinner = this.batterySpinner.getSpinner();
        int n = -5;
        jSpinner.setBounds(point.x, point.y + jSpinner.getPreferredSize().height + n, jSpinner.getPreferredSize().width, jSpinner.getPreferredSize().height);
        jSpinner.repaint();
    }

    private void addViewBoundsListener() {
        this.getApparatusPanel().addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                ConductivityApplication.this.setTransform();
            }

            public void componentShown(ComponentEvent componentEvent) {
                ConductivityApplication.this.setTransform();
            }
        });
    }

    void setTransform() {
        Rectangle rectangle = new Rectangle(0, 0, this.getApparatusPanel().getWidth(), this.getApparatusPanel().getHeight());
        this.transform.setViewBounds(rectangle);
        this.getApparatusPanel().repaint();
    }

    public void setBandSet(DefaultBandSet defaultBandSet) {
        DefaultBandSet defaultBandSet2 = this.model.getBandSet();
        BandSetGraphic bandSetGraphic = (BandSetGraphic)this.bandSetGraphicTable.get(defaultBandSet2);
        if (bandSetGraphic != null) {
            this.getApparatusPanel().removeGraphic(bandSetGraphic);
        }
        BandSetGraphic bandSetGraphic2 = this.getBandSetGraphic(defaultBandSet);
        defaultBandSet.initParticles();
        this.getApparatusPanel().addGraphic(bandSetGraphic2);
        this.model.setBandSet(defaultBandSet);
        this.model.doVoltageChanged();
    }

    private BandSetGraphic getBandSetGraphic(DefaultBandSet defaultBandSet) {
        BandSetGraphic bandSetGraphic = (BandSetGraphic)this.bandSetGraphicTable.get(defaultBandSet);
        if (bandSetGraphic == null) {
            bandSetGraphic = new BandSetGraphic(this.transform, defaultBandSet.getBounds(), defaultBandSet);
            defaultBandSet.addBandParticleObserver(bandSetGraphic);
            this.bandSetGraphicTable.put(defaultBandSet, bandSetGraphic);
        }
        return bandSetGraphic;
    }

    public void setConductor() {
        this.setBandSet(this.model.getConductor());
        this.circuitGraphic.getResistorGraphic().setFillPaint(new Color(210, 210, 210));
        this.circuitGraphic.getResistorGraphic().setOutlinePaint(new Color(210, 210, 210));
        this.enableFlashlight();
    }

    public void setInsulator() {
        this.setBandSet(this.model.getInsulator());
        this.macroControlPanel.disableFlashlight();
        this.circuitGraphic.getResistorGraphic().setFillPaint(Color.orange);
        this.circuitGraphic.getResistorGraphic().setOutlinePaint(Color.orange);
        this.enableFlashlight();
    }

    public void setPhotoconductor() {
        this.setBandSet(this.model.getPhotoconductor());
        this.macroControlPanel.enableFlashlight();
        this.circuitGraphic.getResistorGraphic().setFillPaint(Color.yellow);
        this.circuitGraphic.getResistorGraphic().setOutlinePaint(Color.yellow);
        this.enableFlashlight();
    }

    private void enableFlashlight() {
        this.macroControlPanel.enableFlashlight();
        this.flashlightGraphic.setVisible(true);
    }

    public void setFlashlightOn(boolean bl) {
        this.lightOn = bl;
        this.model.getPhotoconductor().setFlashlightOn(bl);
    }

    public void firePhoton() {
        ImmutableVector2D immutableVector2D = this.getResistorCenter();
        Photon photon = new Photon();
        photon.setPosition(this.light.getPosition());
        double d = 0.01;
        ImmutableVector2D immutableVector2D2 = immutableVector2D.getSubtractedInstance(photon.getPosition()).getInstanceOfMagnitude(d);
        photon.setVelocity(immutableVector2D2);
        PhotonArrowGraphic photonArrowGraphic = new PhotonArrowGraphic(photon, this.transform);
        this.getApparatusPanel().addGraphic(photonArrowGraphic, 3.0);
        this.photons.add(photon);
        this.photonGraphicTable.put(photon, photonArrowGraphic);
    }

    public ApparatusPanel getApparatusPanel() {
        return this.apparatusPanel;
    }

    public BaseModel getBaseModel() {
        return this.baseModel;
    }

    public void stopClock() {
        this.clock.pause();
    }

    public void startClock() {
        this.clock.start();
    }

    public static void main(String[] stringArray) {
        ApplicationConstructor applicationConstructor = new ApplicationConstructor(){

            public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                return new ConductivityPhetApplication(phetApplicationConfig);
            }
        };
        PhetApplicationConfig phetApplicationConfig = new PhetApplicationConfig(stringArray, "conductivity");
        phetApplicationConfig.getLookAndFeel().setBackgroundColor(new Color(245, 245, 255));
        new PhetApplicationLauncher().launchSim(phetApplicationConfig, applicationConstructor);
    }

    private static class ConductivityModule
    extends Module {
        public ConductivityModule(PhetApplicationConfig phetApplicationConfig) {
            super("name", new ConstantDtClock(30, 1.0));
            try {
                ConductivityApplication conductivityApplication = new ConductivityApplication(this.getClock());
                this.setSimulationPanel(conductivityApplication.getApparatusPanel());
                this.setControlPanel(conductivityApplication.controlPanel);
                this.getClock().addClockListener(new ClockAdapter(){

                    public void clockTicked(ClockEvent clockEvent) {
                        ConductivityModule.this.getSimulationPanel().validate();
                        ConductivityModule.this.getSimulationPanel().repaint();
                    }
                });
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static class ConductivityPhetApplication
    extends PhetApplication {
        protected ConductivityPhetApplication(PhetApplicationConfig phetApplicationConfig) {
            super(phetApplicationConfig);
            this.addModule(new ConductivityModule(phetApplicationConfig));
        }
    }
}

