/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.colorvision.view;

import edu.colorado.phet.colorvision.model.SolidBeam;
import edu.colorado.phet.colorvision.view.BoundsOutliner;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;

public class SolidBeamGraphic
extends PhetShapeGraphic
implements SimpleObserver {
    private SolidBeam _beamModel;
    private double _alphaScale;

    public SolidBeamGraphic(Component component, SolidBeam solidBeam) {
        super(component, null, null);
        this._beamModel = solidBeam;
        this._alphaScale = 100.0;
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.setRenderingHints(renderingHints);
        super.setPaint(Color.white);
        super.setStroke(null);
        this.update();
    }

    public void setAlphaScale(double d) {
        this._alphaScale = d;
        this.update();
    }

    public void update() {
        if (!this._beamModel.isEnabled()) {
            super.setShape(null);
        } else {
            VisibleColor visibleColor = this._beamModel.getPerceivedColor();
            int n = visibleColor.getRed();
            int n2 = visibleColor.getGreen();
            int n3 = visibleColor.getBlue();
            int n4 = (int)((double)visibleColor.getAlpha() * this._alphaScale / 100.0);
            super.setPaint(new Color(n, n2, n3, n4));
            double d = this._beamModel.getX();
            double d2 = this._beamModel.getY();
            double d3 = this._beamModel.getDistance();
            double d4 = this._beamModel.getDirection();
            double d5 = this._beamModel.getCutOffAngle();
            double d6 = d3 / Math.cos(Math.toRadians(d5 / 2.0));
            double d7 = d;
            double d8 = d2;
            double d9 = Math.toRadians(d4 - d5 / 2.0);
            double d10 = d6 * Math.cos(d9);
            double d11 = d6 * Math.sin(d9);
            d10 += d;
            d11 += d2;
            double d12 = Math.toRadians(d4 + d5 / 2.0);
            double d13 = d6 * Math.cos(d12);
            double d14 = d6 * Math.sin(d12);
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo((int)d7, (int)d8);
            generalPath.lineTo((int)d10, (int)d11);
            generalPath.lineTo((int)(d13 += d), (int)(d14 += d2));
            generalPath.closePath();
            super.setShape(generalPath);
        }
    }

    public void paint(Graphics2D graphics2D) {
        if (super.isVisible() && this._beamModel.isEnabled()) {
            super.paint(graphics2D);
            BoundsOutliner.paint(graphics2D, this);
        }
    }
}

