/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.colorvision.view;

import edu.colorado.phet.colorvision.view.BoundsOutliner;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;

public class PipeGraphic
extends PhetShapeGraphic {
    private ArrayList _pipes = new ArrayList();
    private int _thickness = 5;
    private int _arc = 10;
    private Point _location = new Point(0, 0);

    public PipeGraphic(Component component) {
        super(component, null, null);
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.setRenderingHints(renderingHints);
        super.setPaint(Color.GRAY);
        super.setStroke(new BasicStroke(1.0f));
        super.setBorderColor(Color.GRAY);
    }

    public void setThickness(int n) {
        this._thickness = n;
    }

    public void setLocation(Point point) {
        int n = point.x - this._location.x;
        int n2 = point.y - this._location.y;
        this._location = point;
        for (int i = 0; i < this._pipes.size(); ++i) {
            RoundRectangle2D.Double double_ = (RoundRectangle2D.Double)this._pipes.get(i);
            double_.x += (double)n;
            double_.y += (double)n2;
        }
        this.updateShape();
    }

    public void setLocation(int n, int n2) {
        this.setLocation(new Point(n, n2));
    }

    public Point getLocation() {
        return this._location;
    }

    public void addSegment(int n, int n2, int n3, int n4) {
        RoundRectangle2D.Double double_;
        if (n == 0) {
            double_ = new RoundRectangle2D.Double(n2 + this._location.x, n3 + this._location.y, n4, this._thickness, this._arc, this._arc);
        } else if (n == 1) {
            double_ = new RoundRectangle2D.Double(n2 + this._location.x, n3 + this._location.y, this._thickness, n4, this._arc, this._arc);
        } else {
            throw new IllegalArgumentException("invalid orientation: " + n);
        }
        this._pipes.add(double_);
        this.updateShape();
    }

    private void updateShape() {
        Area area = new Area();
        for (int i = 0; i < this._pipes.size(); ++i) {
            RoundRectangle2D.Double double_ = (RoundRectangle2D.Double)this._pipes.get(i);
            area.add(new Area(double_));
        }
        super.setShape(area);
    }

    public void paint(Graphics2D graphics2D) {
        if (super.isVisible()) {
            super.paint(graphics2D);
            BoundsOutliner.paint(graphics2D, this);
        }
    }
}

