/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.colorvision.view;

import edu.colorado.phet.colorvision.model.Person;
import edu.colorado.phet.colorvision.view.ThoughtBubbleGraphic;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import java.awt.Component;

public class PersonGraphic
extends CompositePhetGraphic
implements SimpleObserver {
    private Person _personModel;
    private PhetImageGraphic _headBackgroundGraphic;
    private PhetImageGraphic _headForegroundGraphic;
    private ThoughtBubbleGraphic _thoughtBubbleGraphic;
    private double _x;
    private double _y;

    public PersonGraphic(ApparatusPanel apparatusPanel, double d, double d2, Person person) {
        super(apparatusPanel);
        this._personModel = person;
        this._headBackgroundGraphic = new PhetImageGraphic((Component)apparatusPanel, "color-vision/images/headBackground.png");
        this.addGraphic(this._headBackgroundGraphic);
        this._headForegroundGraphic = new PhetImageGraphic((Component)apparatusPanel, "color-vision/images/headForeground.png");
        this.addGraphic(this._headForegroundGraphic);
        this._thoughtBubbleGraphic = new ThoughtBubbleGraphic(apparatusPanel);
        this.addGraphic(this._thoughtBubbleGraphic);
        apparatusPanel.addGraphic(this._headBackgroundGraphic, d);
        apparatusPanel.addGraphic(this._headForegroundGraphic, d2);
        apparatusPanel.addGraphic(this._thoughtBubbleGraphic, d2);
        this.update();
    }

    public void update() {
        double d = this._personModel.getX();
        double d2 = this._personModel.getY();
        if (d != this._x || d2 != this._y) {
            this._x = d;
            this._y = d2;
            this._headBackgroundGraphic.setLocation((int)(d + 0.0), (int)(d2 + 165.0));
            this._headForegroundGraphic.setLocation((int)(d + 0.0), (int)(d2 + 165.0));
            this._thoughtBubbleGraphic.setLocation((int)(d + 120.0), (int)(d2 + 5.0));
        }
        this._thoughtBubbleGraphic.setPaint(this._personModel.getColor().toColor());
        super.repaint();
    }
}

