/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.colorvision.model;

import edu.colorado.phet.colorvision.event.VisibleColorChangeEvent;
import edu.colorado.phet.colorvision.event.VisibleColorChangeListener;
import edu.colorado.phet.colorvision.model.Filter;
import edu.colorado.phet.colorvision.model.Photon;
import edu.colorado.phet.colorvision.model.Spotlight;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.util.SimpleObservable;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.event.EventListenerList;

public class PhotonBeam
extends SimpleObservable
implements ModelElement,
SimpleObserver {
    private Spotlight _spotlightModel;
    private Filter _filterModel;
    private Rectangle _bounds;
    private VisibleColor _perceivedColor;
    private double _perceivedIntensity;
    private ArrayList _photons;
    private EventListenerList _listenerList;
    private boolean _enabled;
    private int _maxPhotons;

    public PhotonBeam(Spotlight spotlight, Filter filter) {
        this._spotlightModel = spotlight;
        this._filterModel = filter;
        this._bounds = new Rectangle((int)this._spotlightModel.getX(), (int)this._spotlightModel.getY(), 100, 100);
        this._perceivedColor = VisibleColor.INVISIBLE;
        this._perceivedIntensity = 0.0;
        this._photons = new ArrayList();
        this._listenerList = new EventListenerList();
        this._enabled = true;
        this._maxPhotons = 20;
    }

    public PhotonBeam(Spotlight spotlight) {
        this(spotlight, null);
    }

    public final ArrayList getPhotons() {
        return this._photons;
    }

    public Rectangle getBounds() {
        return this._bounds;
    }

    public void setBounds(Rectangle rectangle) {
        this._bounds = rectangle;
        this.notifyObservers();
    }

    public double getPerceivedIntensity() {
        return this._perceivedIntensity;
    }

    public void setEnabled(boolean bl) {
        this._enabled = bl;
        this.notifyObservers();
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setMaxPhotons(int n) {
        this._maxPhotons = n;
    }

    public void stepInTime(double d) {
        Photon photon;
        int n;
        int n2 = 0;
        int n3 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        VisibleColor visibleColor = this._perceivedColor;
        double d4 = this._perceivedIntensity;
        ArrayList<Photon> arrayList = new ArrayList<Photon>();
        double d5 = 0.0;
        boolean bl = this._filterModel != null;
        boolean bl2 = this._filterModel != null && this._filterModel.isEnabled();
        int n4 = 0;
        if (this._spotlightModel.getIntensity() == 0.0 && this._perceivedIntensity != 0.0) {
            n4 = 1;
        } else {
            double d6 = this._spotlightModel.getIntensity();
            n4 = (int)(d6 / 100.0 * (double)this._maxPhotons);
            if (d6 != 0.0 && n4 == 0) {
                n4 = 1;
            }
        }
        for (n = 0; n < this._photons.size(); ++n) {
            photon = (Photon)this._photons.get(n);
            if (photon.isInUse()) {
                ++n2;
                photon.stepInTime(d);
                if (!this._bounds.contains(photon.getX(), photon.getY())) {
                    photon.setInUse(false);
                    visibleColor = photon.getColor();
                    d4 = photon.getIntensity();
                } else if (bl && !photon.isFiltered() && photon.getX() > this._filterModel.getX() + 12.0) {
                    photon.setFiltered(true);
                    if (bl2) {
                        double d7 = this._filterModel.percentPassed(photon.getColor());
                        if (d7 == 0.0) {
                            photon.setInUse(false);
                            d2 = photon.getX();
                            d3 = photon.getY();
                        } else {
                            arrayList.add(photon);
                            photon.setLocation(photon.getX() + 20.0, photon.getY());
                            photon.setIntensity(d7);
                            ++n3;
                            d5 = d7;
                        }
                    }
                }
            }
            if (photon.isInUse() || n4 <= 0) continue;
            this.reusePhoton(photon);
            --n4;
        }
        if (arrayList.size() > 0) {
            n = arrayList.size();
            Photon photon2 = (Photon)arrayList.get(n - 1);
            double d8 = photon2.getColor().getWavelength();
            boolean bl3 = d8 == 0.0;
            int n5 = 0;
            if (bl3) {
                n5 = (int)((double)n * 0.85);
            } else {
                n5 = (int)((double)n - (double)n * d5 / 100.0);
                if (n5 == n && d5 > 0.0) {
                    n5 = n - 1;
                }
            }
            for (int i = 0; i < n5; ++i) {
                photon = (Photon)arrayList.get(i);
                photon.setInUse(false);
                --n3;
                if (n4 <= 0) continue;
                this.reusePhoton(photon);
                --n4;
            }
            if (bl3) {
                VisibleColor visibleColor2 = this._filterModel.getTransmissionPeak();
                for (int i = n5; i < n; ++i) {
                    ((Photon)arrayList.get(i)).setColor(visibleColor2);
                }
            }
        }
        while (n4 > 0) {
            photon = new Photon(this._spotlightModel.getColor(), this._spotlightModel.getIntensity(), this.genX(this._spotlightModel.getX()), this._spotlightModel.getY(), this.genDirection(this._spotlightModel.getDirection()));
            this._photons.add(photon);
            --n4;
        }
        if (bl2 && n3 == 0 && this._perceivedColor.getWavelength() != 781.0) {
            n = 0;
            int n6 = 0;
            while (n6 < this._photons.size() & n == 0) {
                photon = (Photon)this._photons.get(n6);
                if (!photon.isInUse()) {
                    n = 1;
                    photon.setInUse(true);
                    photon.setFiltered(true);
                    photon.setLocation(d2, d3);
                    photon.setDirection(this._spotlightModel.getDirection());
                    photon.setColor(VisibleColor.INVISIBLE);
                    photon.setIntensity(0.0);
                }
                ++n6;
            }
            if (n == 0) {
                photon = new Photon(VisibleColor.INVISIBLE, 0.0, d2, d3, this._spotlightModel.getDirection());
                this._photons.add(photon);
            }
        }
        if (d4 != this._perceivedIntensity || visibleColor.getWavelength() != this._perceivedColor.getWavelength()) {
            this._perceivedColor = visibleColor;
            this._perceivedIntensity = d4;
            if (this._enabled) {
                n = this._perceivedColor.getRed();
                int n7 = this._perceivedColor.getGreen();
                int n8 = this._perceivedColor.getBlue();
                int n9 = (int)((double)this._perceivedColor.getAlpha() * this._perceivedIntensity / 100.0);
                VisibleColor visibleColor3 = new VisibleColor(n, n7, n8, n9);
                VisibleColorChangeEvent visibleColorChangeEvent = new VisibleColorChangeEvent(this, visibleColor3);
                this.fireColorChangeEvent(visibleColorChangeEvent);
            }
        }
        if (this._enabled && n2 > 0) {
            this.notifyObservers();
        }
    }

    private double genX(double d) {
        return d + Math.random() * 10.0;
    }

    private double genDirection(double d) {
        double d2 = Math.random() * this._spotlightModel.getCutOffAngle() / 2.0;
        return d + (d2 *= Math.random() > 0.5 ? 1.0 : -1.0);
    }

    private void reusePhoton(Photon photon) {
        if (photon.isInUse()) {
            throw new IllegalArgumentException("the photon provided is still in use");
        }
        double d = this.genX(this._spotlightModel.getX());
        double d2 = this._spotlightModel.getY();
        double d3 = this.genDirection(this._spotlightModel.getDirection());
        photon.setInUse(true);
        photon.setFiltered(false);
        photon.setLocation(d, d2);
        photon.setDirection(d3);
        photon.setColor(this._spotlightModel.getColor());
        photon.setIntensity(this._spotlightModel.getIntensity());
    }

    public void update() {
    }

    public void addColorChangeListener(VisibleColorChangeListener visibleColorChangeListener) {
        this._listenerList.add(VisibleColorChangeListener.class, visibleColorChangeListener);
    }

    private void fireColorChangeEvent(VisibleColorChangeEvent visibleColorChangeEvent) {
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != VisibleColorChangeListener.class) continue;
            ((VisibleColorChangeListener)objectArray[i + 1]).colorChanged(visibleColorChangeEvent);
        }
    }
}

