/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.colorvision.control;

import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

class SpectrumSliderKnob
extends PhetShapeGraphic {
    private Point _location = new Point(0, 0);
    private Dimension _size;
    private double _angle;

    public SpectrumSliderKnob(Component component, Dimension dimension, double d) {
        super(component, null, null);
        this._size = new Dimension(dimension);
        this._angle = d;
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.setRenderingHints(renderingHints);
        super.setPaint(Color.WHITE);
        super.setStroke(new BasicStroke(1.0f));
        super.setBorderColor(Color.BLACK);
        this.updateShape();
    }

    public void setLocation(Point point) {
        super.translate(-this._location.x, -this._location.y);
        this._location = new Point(point);
        super.translate(point.x, point.y);
    }

    public void setLocation(int n, int n2) {
        this.setLocation(new Point(n, n2));
    }

    public Point getLocation() {
        return new Point(this._location);
    }

    private void updateShape() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 0.0f);
        generalPath.lineTo(-0.5f * (float)this._size.width, 0.3f * (float)this._size.height);
        generalPath.lineTo(-0.5f * (float)this._size.width, 1.0f * (float)this._size.height);
        generalPath.lineTo(0.5f * (float)this._size.width, 1.0f * (float)this._size.height);
        generalPath.lineTo(0.5f * (float)this._size.width, 0.3f * (float)this._size.height);
        generalPath.closePath();
        Shape shape = generalPath;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(this._location.x, this._location.y);
        affineTransform.rotate(this._angle);
        shape = affineTransform.createTransformedShape(shape);
        super.setShape(shape);
    }
}

