/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.colorvision.control;

import edu.colorado.phet.colorvision.control.SpectrumSliderKnob;
import edu.colorado.phet.colorvision.view.BellCurve;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputAdapter;

public class SpectrumSlider
extends GraphicLayerSet {
    private static final Dimension DEFAULT_KNOB_SIZE = new Dimension(20, 30);
    private static final double HORIZONTAL_ROTATION_ANGLE = Math.toRadians(0.0);
    private static final double VERTICAL_ROTATION_ANGLE = Math.toRadians(-90.0);
    private Component _component;
    private int _value;
    private int _minimum;
    private int _maximum;
    private double _transmissionWidth;
    private Point _location;
    private int _orientation;
    private Rectangle _dragBounds;
    private int _mouseOffset;
    private EventListenerList _listenerList;
    private PhetImageGraphic _spectrum;
    private SpectrumSliderKnob _knob;

    public SpectrumSlider(Component component) {
        super(null);
        this._component = component;
        this._minimum = 380;
        this._maximum = 780;
        this._value = this._minimum;
        this._orientation = 0;
        this._transmissionWidth = 0.0;
        this._dragBounds = new Rectangle(0, 0, 0, 0);
        this._mouseOffset = 0;
        this._listenerList = new EventListenerList();
        this._spectrum = new PhetImageGraphic(component, "color-vision/images/spectrum.png");
        this.addGraphic(this._spectrum);
        this._knob = new SpectrumSliderKnob(component, DEFAULT_KNOB_SIZE, this.getRotationAngle());
        this.addGraphic(this._knob);
        this._knob.setCursorHand();
        this._knob.addMouseInputListener(new SpectrumSliderMouseInputListener());
        this.setLocation(0, 0);
    }

    public void setValue(int n) {
        this._value = (int)MathUtil.clamp(this._minimum, n, this._maximum);
        this.fireChangeEvent(new ChangeEvent(this));
        this.updateKnob();
    }

    public int getValue() {
        return this._value;
    }

    private int getValue(int n, int n2) {
        double d = this._orientation == 0 ? (double)(n - this._dragBounds.x) / (double)this._dragBounds.width : 1.0 - (double)(n2 - this._dragBounds.y) / (double)this._dragBounds.height;
        int n3 = (int)(d * (double)(this._maximum - this._minimum)) + this._minimum;
        return n3;
    }

    public void setTransmissionWidth(double d) {
        this._transmissionWidth = d;
        this.repaint();
    }

    public void setLocation(Point point) {
        this._location = point;
        this.updateUI();
    }

    public void setLocation(int n, int n2) {
        this.setLocation(new Point(n, n2));
    }

    public Point getLocation() {
        return this._location;
    }

    public Rectangle getBounds() {
        Rectangle rectangle = new Rectangle(this._spectrum.getBounds());
        rectangle.add(this._knob.getBounds());
        return rectangle;
    }

    public void setVisible(boolean bl) {
        if (bl != super.isVisible()) {
            super.setVisible(bl);
            this.repaint();
        }
    }

    public void setKnobBorderColor(Color color) {
        this._knob.setBorderColor(color);
        this.repaint();
    }

    private int getCurveWidth() {
        int n = this._orientation == 0 ? this._spectrum.getBounds().width : this._spectrum.getBounds().height;
        int n2 = (int)(this._transmissionWidth * (double)n / (double)(this._maximum - this._minimum));
        return n2;
    }

    private double getRotationAngle() {
        double d = this._orientation == 0 ? HORIZONTAL_ROTATION_ANGLE : VERTICAL_ROTATION_ANGLE;
        return d;
    }

    private void updateUI() {
        Rectangle rectangle = this._spectrum.getBounds();
        Rectangle rectangle2 = this._knob.getBounds();
        int n = this._location.x;
        int n2 = this._location.y;
        if (this._orientation == 0) {
            this._spectrum.setLocation(n, n2);
            this._dragBounds = new Rectangle(n, n2 + rectangle.height, rectangle.width, 0);
        } else {
            double d = this.getRotationAngle();
            AffineTransform affineTransform = AffineTransform.getRotateInstance(d);
            this._spectrum.setTransform(affineTransform);
            this._spectrum.setLocation(n, n2 + rectangle.height);
            this._dragBounds = new Rectangle(n + rectangle.width, n2, 0, rectangle.height);
        }
        this.updateKnob();
    }

    private void updateKnob() {
        int n;
        int n2;
        double d;
        if (this._orientation == 0) {
            d = (double)(this._value - this._minimum) / (double)(this._maximum - this._minimum);
            n2 = this._dragBounds.x + (int)(d * (double)this._dragBounds.width);
            n = this._dragBounds.y;
        } else {
            d = 1.0 - (double)(this._value - this._minimum) / (double)(this._maximum - this._minimum);
            n2 = this._dragBounds.x;
            n = this._dragBounds.y + (int)(d * (double)this._dragBounds.height);
        }
        this._knob.setLocation(n2, n);
        VisibleColor visibleColor = new VisibleColor((double)this._value);
        this._knob.setPaint(visibleColor.toColor());
        this.repaint();
    }

    public void repaint() {
        Rectangle rectangle = this.getBounds();
        this._component.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void paint(Graphics2D graphics2D) {
        if (super.isVisible()) {
            super.paint(graphics2D);
            if (this._transmissionWidth > 0.0) {
                int n;
                int n2;
                int n3;
                int n4;
                if (this._orientation == 0) {
                    n4 = this._knob.getLocation().x;
                    n3 = this._spectrum.getBounds().y;
                    n2 = this.getCurveWidth();
                    n = this._spectrum.getBounds().height;
                } else {
                    n4 = this._spectrum.getBounds().x;
                    n3 = this._knob.getLocation().y;
                    n2 = this.getCurveWidth();
                    n = this._spectrum.getBounds().width;
                }
                BellCurve bellCurve = new BellCurve(this._component, n4, n3, n2, n, this.getRotationAngle());
                Shape shape = graphics2D.getClip();
                graphics2D.setClip(this._spectrum.getBounds());
                bellCurve.paint(graphics2D);
                graphics2D.setClip(shape);
            }
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._listenerList.add(ChangeListener.class, changeListener);
    }

    private void fireChangeEvent(ChangeEvent changeEvent) {
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    private class SpectrumSliderMouseInputListener
    extends MouseInputAdapter {
        private SpectrumSliderMouseInputListener() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n;
            int n2;
            if (SpectrumSlider.this._orientation == 0) {
                n2 = mouseEvent.getX() - SpectrumSlider.this._mouseOffset;
                n = mouseEvent.getY();
            } else {
                n2 = mouseEvent.getX();
                n = mouseEvent.getY() - SpectrumSlider.this._mouseOffset;
            }
            int n3 = Math.max(((SpectrumSlider)SpectrumSlider.this)._dragBounds.x, Math.min(((SpectrumSlider)SpectrumSlider.this)._dragBounds.x + ((SpectrumSlider)SpectrumSlider.this)._dragBounds.width, n2));
            int n4 = Math.max(((SpectrumSlider)SpectrumSlider.this)._dragBounds.y, Math.min(((SpectrumSlider)SpectrumSlider.this)._dragBounds.y + ((SpectrumSlider)SpectrumSlider.this)._dragBounds.height, n));
            int n5 = SpectrumSlider.this.getValue(n3, n4);
            if (n5 != SpectrumSlider.this.getValue()) {
                SpectrumSlider.this.setValue(n5);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (SpectrumSlider.this._orientation == 0) {
                SpectrumSlider.this._mouseOffset = mouseEvent.getX() - ((SpectrumSlider)SpectrumSlider.this)._knob.getLocation().x;
            } else {
                SpectrumSlider.this._mouseOffset = mouseEvent.getY() - ((SpectrumSlider)SpectrumSlider.this)._knob.getLocation().y;
            }
        }
    }
}

