/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.colorvision.control;

import edu.colorado.phet.colorvision.control.SpectrumSliderKnob;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputAdapter;

public class ColorIntensitySlider
extends GraphicLayerSet {
    private final int MIN = 0;
    private final int MAX = 100;
    private final int TRACK_MARGIN = 15;
    private final int TRACK_WIDTH = 3;
    private int _value = 0;
    private Point _location;
    private Rectangle _dragBounds = new Rectangle(0, 0, 0, 0);
    private final EventListenerList _listenerList = new EventListenerList();
    private final PhetShapeGraphic _background;
    private final PhetShapeGraphic _track;
    private final SpectrumSliderKnob _knob;

    public ColorIntensitySlider(Component component, Color color, Dimension dimension) {
        super(component);
        GradientPaint gradientPaint = new GradientPaint(0.0f, 15.0f, color, 0.0f, dimension.height - 15, Color.BLACK);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, dimension.width, dimension.height);
        this._background = new PhetShapeGraphic(component, double_, gradientPaint, new BasicStroke(1.0f), Color.WHITE);
        this.addGraphic(this._background);
        Rectangle2D.Double double_2 = new Rectangle2D.Double((dimension.width - 3) / 2, 15.0, 3.0, dimension.height - 30);
        this._track = new PhetShapeGraphic(component, double_2, Color.LIGHT_GRAY, new BasicStroke(0.5f), Color.DARK_GRAY);
        this.addGraphic(this._track);
        this._knob = new SpectrumSliderKnob(component, new Dimension(15, 20), Math.toRadians(-90.0));
        this._knob.setPaint(Color.GRAY);
        this._knob.setBorderColor(Color.WHITE);
        this.addGraphic(this._knob);
        this._knob.setCursorHand();
        this._knob.addMouseInputListener(new KnobDragListener());
        this.setLocation(0, 0);
    }

    public void setValue(int n) {
        this._value = (int)MathUtil.clamp(0.0, n, 100.0);
        this.fireChangeEvent(new ChangeEvent(this));
        this.updateKnob();
    }

    public int getValue() {
        return this._value;
    }

    private int getValue(int n, int n2) {
        double d = 1.0 - (double)(n2 - this._dragBounds.y) / (double)this._dragBounds.height;
        int n3 = (int)(d * 100.0) + 0;
        return n3;
    }

    public void setLocation(Point point) {
        this._location = point;
        this.updateUI();
    }

    private void updateUI() {
        int n = this._location.x;
        int n2 = this._location.y;
        this._background.setLocation(n, n2);
        this._track.setLocation(n, n2);
        this._dragBounds = new Rectangle(n + (this._background.getBounds().width - this._knob.getWidth()) / 2, n2 + 15, 0, this._background.getBounds().height - 30);
        this.updateKnob();
    }

    private void updateKnob() {
        double d = 1.0 - (double)(this._value - 0) / 100.0;
        int n = this._dragBounds.x;
        int n2 = this._dragBounds.y + (int)(d * (double)this._dragBounds.height);
        this._knob.setLocation(n, n2);
        this.repaint();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._listenerList.add(ChangeListener.class, changeListener);
    }

    private void fireChangeEvent(ChangeEvent changeEvent) {
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    private class KnobDragListener
    extends MouseInputAdapter {
        private int _mouseOffset;

        private KnobDragListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this._mouseOffset = mouseEvent.getY() - ((ColorIntensitySlider)ColorIntensitySlider.this)._knob.getLocation().y;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n;
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY() - this._mouseOffset;
            int n4 = Math.max(((ColorIntensitySlider)ColorIntensitySlider.this)._dragBounds.x, Math.min(((ColorIntensitySlider)ColorIntensitySlider.this)._dragBounds.x + ((ColorIntensitySlider)ColorIntensitySlider.this)._dragBounds.width, n2));
            int n5 = ColorIntensitySlider.this.getValue(n4, n = Math.max(((ColorIntensitySlider)ColorIntensitySlider.this)._dragBounds.y, Math.min(((ColorIntensitySlider)ColorIntensitySlider.this)._dragBounds.y + ((ColorIntensitySlider)ColorIntensitySlider.this)._dragBounds.height, n3)));
            if (n5 != ColorIntensitySlider.this.getValue()) {
                ColorIntensitySlider.this.setValue(n5);
            }
        }
    }
}

