/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.colorvision;

import edu.colorado.phet.colorvision.ColorVisionConstants;
import edu.colorado.phet.colorvision.ColorVisionStrings;
import edu.colorado.phet.colorvision.control.SingleBulbControlPanel;
import edu.colorado.phet.colorvision.control.SpectrumSlider;
import edu.colorado.phet.colorvision.control.ToggleSwitch;
import edu.colorado.phet.colorvision.event.VisibleColorChangeEvent;
import edu.colorado.phet.colorvision.event.VisibleColorChangeListener;
import edu.colorado.phet.colorvision.help.FilterSliderWiggleMe;
import edu.colorado.phet.colorvision.model.Filter;
import edu.colorado.phet.colorvision.model.Person;
import edu.colorado.phet.colorvision.model.PhotonBeam;
import edu.colorado.phet.colorvision.model.SolidBeam;
import edu.colorado.phet.colorvision.model.Spotlight;
import edu.colorado.phet.colorvision.view.FilterGraphic;
import edu.colorado.phet.colorvision.view.FilterHolderGraphic;
import edu.colorado.phet.colorvision.view.PersonGraphic;
import edu.colorado.phet.colorvision.view.PhotonBeamGraphic;
import edu.colorado.phet.colorvision.view.PipeGraphic;
import edu.colorado.phet.colorvision.view.SolidBeamGraphic;
import edu.colorado.phet.colorvision.view.SpotlightGraphic;
import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetcommon.model.clock.SwingClock;
import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;
import edu.colorado.phet.common.phetgraphics.application.PhetGraphicsModule;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel3;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SingleBulbModule
extends PhetGraphicsModule
implements VisibleColorChangeListener,
ChangeListener {
    private static Color APPARATUS_BACKGROUND = ColorVisionConstants.APPARATUS_BACKGROUND;
    private static Color LABEL_COLOR = ColorVisionConstants.LABEL_COLOR;
    private static Font LABEL_FONT = ColorVisionConstants.LABEL_FONT;
    private static final Point FILTER_SWITCH_LOCATION = new Point(330, 440);
    private static final Point FILTER_HOLDER_LOCATION = new Point(342, 395);
    private static final Point FILTER_SLIDER_LOCATION = new Point(100, 515);
    private static final Point FILTER_SLIDER_LABEL_LOCATION = new Point(100, 490);
    private static final Point FILTER_PIPE_LOCATION = new Point(249, 415);
    private static final Point BULB_SLIDER_LOCATION = new Point(100, 100);
    private static final Point BULB_SLIDER_LABEL_LOCATION = new Point(100, 75);
    private static final Point BULB_PIPE_LOCATION = new Point(50, 112);
    private static final Point WIGGLE_ME_LOCATION = new Point(215, 560);
    private static final Rectangle PHOTON_BEAM_BOUNDS = new Rectangle(120, 250, 430, 150);
    private Person _personModel;
    private Spotlight _spotlightModel;
    private PhotonBeam _photonBeamModel;
    private SolidBeam _preFilterBeamModel;
    private SolidBeam _postFilterBeamModel;
    private Filter _filterModel;
    private SingleBulbControlPanel _controlPanel;
    private SpectrumSlider _filterSlider;
    private SpectrumSlider _bulbSlider;
    private PhetTextGraphic _bulbSliderLabel;
    private ToggleSwitch _filterSwitch;
    private FilterGraphic _filterGraphic;
    private PipeGraphic _filterPipe;
    private PipeGraphic _bulbPipe;
    private SolidBeamGraphic _preFilterBeamGraphic;
    private SolidBeamGraphic _postFilterBeamGraphic;
    private PhotonBeamGraphic _photonBeamGraphic;
    private FilterSliderWiggleMe _wiggleMe;

    public SingleBulbModule() {
        super(ColorVisionStrings.SINGLE_BULB_MODULE_TITLE, new SwingClock(40, 1.0));
        BaseModel baseModel = new BaseModel();
        this.setModel(baseModel);
        this._personModel = new Person();
        this._personModel.setLocation(450.0, 25.0);
        this._spotlightModel = new Spotlight();
        this._spotlightModel.setColor(VisibleColor.WHITE);
        this._spotlightModel.setIntensity(100.0);
        this._spotlightModel.setLocation(120.0, 325.0);
        this._spotlightModel.setDirection(0.0);
        this._spotlightModel.setIntensity(100.0);
        this._filterModel = new Filter();
        this._filterModel.setLocation(337.0, 250.0);
        this._photonBeamModel = new PhotonBeam(this._spotlightModel, this._filterModel);
        this._photonBeamModel.setMaxPhotons(15);
        this._photonBeamModel.setBounds(PHOTON_BEAM_BOUNDS);
        baseModel.addModelElement(this._photonBeamModel);
        this._preFilterBeamModel = new SolidBeam(this._spotlightModel);
        this._preFilterBeamModel.setDistance(230);
        this._postFilterBeamModel = new SolidBeam(this._spotlightModel, this._filterModel);
        this._postFilterBeamModel.setDistance(470);
        ApparatusPanel3 apparatusPanel3 = new ApparatusPanel3(this.getClock(), 850, 630);
        apparatusPanel3.setBackground(APPARATUS_BACKGROUND);
        this.setApparatusPanel(apparatusPanel3);
        PersonGraphic personGraphic = new PersonGraphic(apparatusPanel3, 1.0, 13.0, this._personModel);
        SpotlightGraphic spotlightGraphic = new SpotlightGraphic(apparatusPanel3, this._spotlightModel);
        apparatusPanel3.addGraphic(spotlightGraphic, 12.0);
        this._filterGraphic = new FilterGraphic(apparatusPanel3, this._filterModel);
        apparatusPanel3.addGraphic(this._filterGraphic, 9.0);
        FilterHolderGraphic filterHolderGraphic = new FilterHolderGraphic(apparatusPanel3);
        filterHolderGraphic.setLocation(FILTER_HOLDER_LOCATION);
        apparatusPanel3.addGraphic(filterHolderGraphic, 8.0);
        this._preFilterBeamGraphic = new SolidBeamGraphic(apparatusPanel3, this._preFilterBeamModel);
        this._preFilterBeamGraphic.setAlphaScale(95.0);
        apparatusPanel3.addGraphic(this._preFilterBeamGraphic, 10.0);
        this._postFilterBeamGraphic = new SolidBeamGraphic(apparatusPanel3, this._postFilterBeamModel);
        this._postFilterBeamGraphic.setAlphaScale(100.0);
        apparatusPanel3.addGraphic(this._postFilterBeamGraphic, 7.0);
        this._photonBeamGraphic = new PhotonBeamGraphic(apparatusPanel3, this._photonBeamModel);
        apparatusPanel3.addGraphic(this._photonBeamGraphic, 11.0);
        this._filterSlider = new SpectrumSlider(apparatusPanel3);
        this._filterSlider.setLocation(FILTER_SLIDER_LOCATION);
        this._filterSlider.setKnobBorderColor(Color.WHITE);
        this._filterSlider.setTransmissionWidth(this._filterModel.getTransmissionWidth());
        apparatusPanel3.addGraphic(this._filterSlider, 6.0);
        PhetTextGraphic phetTextGraphic = new PhetTextGraphic(apparatusPanel3, LABEL_FONT, ColorVisionStrings.FILTER_SLIDER_LABEL, LABEL_COLOR, SingleBulbModule.FILTER_SLIDER_LABEL_LOCATION.x, SingleBulbModule.FILTER_SLIDER_LABEL_LOCATION.y);
        apparatusPanel3.addGraphic(phetTextGraphic, 15.0);
        this._bulbSlider = new SpectrumSlider(apparatusPanel3);
        this._bulbSlider.setLocation(BULB_SLIDER_LOCATION);
        this._bulbSlider.setKnobBorderColor(Color.WHITE);
        apparatusPanel3.addGraphic(this._bulbSlider, 3.0);
        this._bulbSliderLabel = new PhetTextGraphic(apparatusPanel3, LABEL_FONT, ColorVisionStrings.BULB_SLIDER_LABEL, LABEL_COLOR, SingleBulbModule.BULB_SLIDER_LABEL_LOCATION.x, SingleBulbModule.BULB_SLIDER_LABEL_LOCATION.y);
        apparatusPanel3.addGraphic(this._bulbSliderLabel, 14.0);
        this._filterPipe = new PipeGraphic(apparatusPanel3);
        this._filterPipe.setThickness(6);
        this._filterPipe.addSegment(0, 0, 110, 105);
        this._filterPipe.addSegment(1, 100, 0, 115);
        this._filterPipe.setLocation(FILTER_PIPE_LOCATION);
        apparatusPanel3.addGraphic(this._filterPipe, 4.0);
        this._bulbPipe = new PipeGraphic(apparatusPanel3);
        this._bulbPipe.setThickness(6);
        this._bulbPipe.addSegment(0, 0, 0, 100);
        this._bulbPipe.addSegment(1, 0, 0, 215);
        this._bulbPipe.addSegment(0, 0, 210, 100);
        this._bulbPipe.setLocation(BULB_PIPE_LOCATION);
        apparatusPanel3.addGraphic(this._bulbPipe, 2.0);
        this._filterSwitch = new ToggleSwitch(apparatusPanel3, "color-vision/images/wallSwitchOn.png", "color-vision/images/wallSwitchOff.png");
        this._filterSwitch.setLocation(FILTER_SWITCH_LOCATION);
        apparatusPanel3.addGraphic(this._filterSwitch, 5.0);
        this._controlPanel = new SingleBulbControlPanel();
        this.setControlPanel(this._controlPanel);
        this._personModel.addObserver(personGraphic);
        this._spotlightModel.addObserver(spotlightGraphic);
        this._spotlightModel.addObserver(this._photonBeamModel);
        this._spotlightModel.addObserver(this._preFilterBeamModel);
        this._spotlightModel.addObserver(this._postFilterBeamModel);
        this._filterModel.addObserver(this._filterGraphic);
        this._filterModel.addObserver(this._photonBeamModel);
        this._filterModel.addObserver(this._postFilterBeamModel);
        this._photonBeamModel.addObserver(this._photonBeamGraphic);
        this._preFilterBeamModel.addObserver(this._preFilterBeamGraphic);
        this._postFilterBeamModel.addObserver(this._postFilterBeamGraphic);
        this._controlPanel.addChangeListener(this);
        this._filterSlider.addChangeListener(this);
        this._bulbSlider.addChangeListener(this);
        this._filterSwitch.addChangeListener(this);
        this._photonBeamModel.addColorChangeListener(this);
        this._postFilterBeamModel.addColorChangeListener(this);
        this._wiggleMe = new FilterSliderWiggleMe(apparatusPanel3, baseModel);
        this._wiggleMe.setLocation(WIGGLE_ME_LOCATION);
        apparatusPanel3.addGraphic(this._wiggleMe, 16.0);
        super.setHelpEnabled(false);
        this._controlPanel.setBulbType(0);
        this._controlPanel.setBeamType(2);
        double d = 580.0;
        this._filterSlider.setValue((int)d);
        this._bulbSlider.setValue((int)d);
        this._filterSwitch.setOn(true);
        this._wiggleMe.start();
    }

    public void colorChanged(VisibleColorChangeEvent visibleColorChangeEvent) {
        if (visibleColorChangeEvent.getSource() != this._photonBeamModel && visibleColorChangeEvent.getSource() != this._postFilterBeamModel) {
            throw new IllegalArgumentException("unexpected VisibleColorChangeEvent from " + visibleColorChangeEvent.getSource());
        }
        this._personModel.setColor(visibleColorChangeEvent.getColor());
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this._filterSlider) {
            if (this._wiggleMe.isRunning()) {
                this._wiggleMe.stop();
                this._wiggleMe.setVisible(false);
            }
            double d = this._filterSlider.getValue();
            this._filterModel.setTransmissionPeak(d);
        } else if (changeEvent.getSource() == this._bulbSlider) {
            VisibleColor visibleColor = VisibleColor.WHITE;
            int n = this._controlPanel.getBulbType();
            if (n == 1) {
                visibleColor = new VisibleColor((double)this._bulbSlider.getValue());
            }
            this._spotlightModel.setColor(visibleColor);
        } else if (changeEvent.getSource() == this._controlPanel || changeEvent.getSource() == this._filterSwitch) {
            int n = this._controlPanel.getBulbType();
            int n2 = this._controlPanel.getBeamType();
            boolean bl = this._filterSwitch.isOn();
            this._filterModel.setEnabled(bl);
            if (n == 0) {
                this._bulbSlider.setVisible(false);
                this._bulbSliderLabel.setVisible(false);
                this._bulbPipe.setVisible(false);
                this._spotlightModel.setColor(VisibleColor.WHITE);
            } else {
                this._bulbSlider.setVisible(true);
                this._bulbSliderLabel.setVisible(true);
                this._bulbPipe.setVisible(true);
                double d = this._bulbSlider.getValue();
                VisibleColor visibleColor = new VisibleColor(d);
                this._spotlightModel.setColor(visibleColor);
            }
            if (n2 == 2) {
                this._photonBeamModel.setEnabled(true);
                this._preFilterBeamModel.setEnabled(false);
                this._postFilterBeamModel.setEnabled(false);
            } else {
                this._photonBeamModel.setEnabled(false);
                this._preFilterBeamModel.setEnabled(bl);
                this._postFilterBeamModel.setEnabled(true);
            }
        } else {
            throw new IllegalArgumentException("unexpected ChangeEvent from " + changeEvent.getSource());
        }
    }
}

