/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo;

import edu.colorado.phet.circuitconstructionkit.CCKModule;
import edu.colorado.phet.circuitconstructionkit.CCKStrings;
import edu.colorado.phet.circuitconstructionkit.model.CircuitListenerAdapter;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.CCKHelpNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.CCKSimulationPanel;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.help.MotionHelpBalloon;
import edu.umd.cs.piccolo.PNode;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class CCKHelpSuite
extends PhetPNode {
    private MotionHelpBalloon motionHelpBalloon;
    private CCKSimulationPanel cckSimulationPanel;
    private CCKModule module;
    private PhetPNode helpNode = new PhetPNode();

    public CCKHelpSuite(CCKSimulationPanel cCKSimulationPanel, CCKModule cCKModule) {
        this.cckSimulationPanel = cCKSimulationPanel;
        this.module = cCKModule;
        this.motionHelpBalloon = new MotionHelpBalloon(cCKSimulationPanel, CCKStrings.getString("CCK3Module.GrabAWire"));
        this.motionHelpBalloon.setArrowVisible(true);
        this.motionHelpBalloon.setBalloonVisible(true);
        this.motionHelpBalloon.setFont(new PhetFont(1, 18));
        this.motionHelpBalloon.setArrowTailPosition(MotionHelpBalloon.RIGHT_CENTER);
        this.addChild(this.motionHelpBalloon);
        cCKSimulationPanel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                CCKHelpSuite.this.motionHelpBalloon.setVisible(false);
            }
        });
        cCKModule.getCircuit().addCircuitListener(new CircuitListenerAdapter(){

            public void branchAdded(Branch branch) {
                CCKHelpSuite.this.motionHelpBalloon.setVisible(false);
            }
        });
        this.helpNode = new CCKHelpNode(cCKSimulationPanel, cCKModule);
        this.addChild(this.helpNode);
        this.setHelpEnabled(false);
    }

    public void applicationStarted() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PNode pNode = CCKHelpSuite.this.cckSimulationPanel.getWireMaker();
                CCKHelpSuite.this.motionHelpBalloon.animateTo(pNode);
            }
        });
    }

    public void setHelpEnabled(boolean bl) {
        this.helpNode.setVisible(bl);
    }
}

