/*
 * Decompiled with CFR 0.152.
 */
package scala;

import java.io.Serializable;
import scala.Function1;
import scala.Function1$class;
import scala.Math$;
import scala.StringBuilder$;
import scala.runtime.BoxesRunTime;

public final class StringBuilder
implements Serializable,
Function1 {
    public static final long serialVersionUID = -8525408645367278351L;
    private int count;
    private char[] value;
    private final String initValue;

    public StringBuilder(int initCapacity, String initValue) {
        this.initValue = initValue;
        Function1$class.$init$(this);
        if (initCapacity < 0) {
            throw new IllegalArgumentException();
        }
        if (initValue == null) {
            throw new NullPointerException();
        }
        this.value = new char[initCapacity + initValue.length()];
        this.count = 0;
        this.append(initValue);
    }

    public Object apply(Object x$1) {
        return BoxesRunTime.boxToCharacter(this.apply(BoxesRunTime.unboxToInt(x$1)));
    }

    public String toString() {
        return new String(this.value(), 0, this.count());
    }

    public StringBuilder append(char x) {
        int newCount = this.count() + 1;
        if (newCount > this.value().length) {
            this.expandCapacity(newCount);
        }
        this.value()[this.count()] = x;
        this.count_$eq(this.count() + 1);
        return this;
    }

    public StringBuilder append(String s) {
        String string = s;
        String str = string == null || string.equals(null) ? "null" : s;
        int len = str.length();
        if (len > 0) {
            int newCount = this.count() + len;
            if (newCount > this.value().length) {
                this.expandCapacity(newCount);
            }
            str.getChars(0, len, this.value(), this.count());
            this.count_$eq(newCount);
        }
        return this;
    }

    public StringBuilder append(Object x) {
        return this.append(String.valueOf(x));
    }

    public char apply(int i) {
        return this.charAt(i);
    }

    public char charAt(int index) {
        if (index < 0 || index >= this.count()) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.value()[index];
    }

    private void expandCapacity(int n) {
        int newCapacity = (this.value().length + 1) * 2;
        this.value_$eq(StringBuilder$.MODULE$.scala$StringBuilder$$copyOf(this.value(), newCapacity < 0 ? Math$.MODULE$.MAX_INT() : (n > newCapacity ? n : newCapacity)));
    }

    public StringBuilder() {
        this(16, "");
    }

    private void count_$eq(int x$1) {
        this.count = x$1;
    }

    private int count() {
        return this.count;
    }

    private void value_$eq(char[] x$1) {
        this.value = x$1;
    }

    private char[] value() {
        return this.value;
    }
}

