/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.util;

import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.resources.PhetResources;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.JTextField;

public class PhetFont
extends Font {
    private static final Font FALLBACK_FONT = new JTextField().getFont().deriveFont(0, 12.0f);
    private static final Font DEFAULT_FONT = PhetFont.createDefaultFont();

    public PhetFont() {
        this(PhetFont.getDefaultFontSize());
    }

    public PhetFont(int n) {
        this(PhetFont.getDefaultFontStyle(), n);
    }

    public PhetFont(int n, int n2) {
        super(PhetFont.getDefaultFontName(), n, n2);
    }

    public PhetFont(int n, boolean bl) {
        this(n, bl, false);
    }

    public PhetFont(int n, boolean bl, boolean bl2) {
        this((bl ? 1 : 0) | (bl2 ? 2 : 0), n);
    }

    public static String getDefaultFontName() {
        return DEFAULT_FONT.getFontName();
    }

    public static int getDefaultFontSize() {
        return DEFAULT_FONT.getSize();
    }

    public static int getDefaultFontStyle() {
        return DEFAULT_FONT.getStyle();
    }

    private static Font createDefaultFont() {
        Font font = FALLBACK_FONT;
        Locale locale = PhetResources.readLocale();
        String[] stringArray = PhetCommonResources.getPreferredFontNames(locale);
        if (stringArray != null) {
            font = PhetFont.getPreferredFont(stringArray, FALLBACK_FONT);
        }
        return font;
    }

    private static Font getPreferredFont(String[] stringArray, Font font) {
        Font font2 = null;
        for (int i = 0; font2 == null && i < stringArray.length; ++i) {
            String string = stringArray[i];
            ArrayList<Font> arrayList = new ArrayList<Font>(Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()));
            for (int j = 0; font2 == null && j < arrayList.size(); ++j) {
                Font font3 = arrayList.get(j);
                if (!font3.getName().equals(string)) continue;
                font2 = font3.deriveFont(font.getStyle(), font.getSize2D());
            }
        }
        if (font2 == null) {
            font2 = font;
        }
        return font2;
    }
}

