/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.view.meters;

import edu.colorado.phet.capacitorlab.view.MinusNode;
import edu.colorado.phet.capacitorlab.view.PlusNode;
import edu.colorado.phet.common.piccolophet.nodes.ButtonNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;

public abstract class ZoomButtonNode
extends ButtonNode {
    private static final Color ENABLED_COLOR = Color.BLACK;
    private static final Color DISABLED_COLOR = Color.GRAY;

    public ZoomButtonNode(String string, boolean bl) {
        super(string, new ZoomIconNode(bl, ENABLED_COLOR), new ZoomIconNode(bl, DISABLED_COLOR));
        this.setBackground(Color.WHITE);
    }

    private static class ZoomIconNode
    extends PComposite {
        private static final Stroke GLASS_STROKE = new BasicStroke(1.8571428f);

        public ZoomIconNode(boolean bl, Color color) {
            PPath pPath = new PPath(new Ellipse2D.Double(0.0, 0.0, 13.0, 13.0));
            pPath.setPaint(new Color(0, 0, 0, 0));
            pPath.setStroke(GLASS_STROKE);
            pPath.setStrokePaint(color);
            this.addChild(pPath);
            PPath pPath2 = new PPath(new Rectangle2D.Double(0.0, 0.0, 2.6, 8.450000000000001));
            pPath2.setStroke(null);
            pPath2.setPaint(color);
            this.addChild(pPath2);
            PNode pNode = bl ? new PlusNode(7.8, 1.3, color) : new MinusNode(7.8, 1.3, color);
            this.addChild(pNode);
            double d = 0.0;
            double d2 = 0.0;
            pPath.setOffset(d, d2);
            d = pPath.getFullBoundsReference().getCenterX() - pPath2.getFullBoundsReference().getWidth() / 2.0;
            d2 = pPath.getFullBoundsReference().getMaxY() - 0.9285714030265808;
            pPath2.setOffset(d, d2);
            d = pPath.getFullBoundsReference().getCenterX();
            d2 = pPath.getFullBoundsReference().getCenterY();
            pNode.setOffset(d, d2);
        }
    }

    public static class ZoomInButtonNode
    extends ZoomButtonNode {
        public ZoomInButtonNode() {
            super("zoomIn", true);
        }
    }

    public static class ZoomOutButtonNode
    extends ZoomButtonNode {
        public ZoomOutButtonNode() {
            super("zoomOut", false);
        }
    }
}

